/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.SleepingAction;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.Subscriptions;

public final class TrampolineScheduler
extends Scheduler {
    private static final TrampolineScheduler INSTANCE = new TrampolineScheduler();
    volatile int counter;
    static final AtomicIntegerFieldUpdater<TrampolineScheduler> COUNTER_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TrampolineScheduler.class, "counter");

    static TrampolineScheduler instance() {
        return INSTANCE;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new InnerCurrentThreadScheduler();
    }

    TrampolineScheduler() {
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static final class TimedAction
    implements Comparable<TimedAction> {
        final Action0 action;
        final Long execTime;
        final int count;

        private TimedAction(Action0 action, Long execTime, int count) {
            this.action = action;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedAction that) {
            int result = this.execTime.compareTo(that.execTime);
            if (result == 0) {
                return TrampolineScheduler.compare(this.count, that.count);
            }
            return result;
        }
    }

    private class InnerCurrentThreadScheduler
    extends Scheduler.Worker
    implements Subscription {
        final PriorityQueue<TimedAction> queue = new PriorityQueue();
        private final BooleanSubscription innerSubscription = new BooleanSubscription();
        private final AtomicInteger wip = new AtomicInteger();

        private InnerCurrentThreadScheduler() {
        }

        @Override
        public Subscription schedule(Action0 action) {
            return this.enqueue(action, this.now());
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            long execTime = this.now() + unit.toMillis(delayTime);
            return this.enqueue(new SleepingAction(action, this, execTime), execTime);
        }

        private Subscription enqueue(Action0 action, long execTime) {
            if (this.innerSubscription.isUnsubscribed()) {
                return Subscriptions.empty();
            }
            final TimedAction timedAction = new TimedAction(action, execTime, COUNTER_UPDATER.incrementAndGet(TrampolineScheduler.this));
            this.queue.add(timedAction);
            if (this.wip.getAndIncrement() == 0) {
                do {
                    TimedAction polled;
                    if ((polled = this.queue.poll()) == null) continue;
                    polled.action.call();
                } while (this.wip.decrementAndGet() > 0);
                return Subscriptions.empty();
            }
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    PriorityQueue<TimedAction> _q = InnerCurrentThreadScheduler.this.queue;
                    if (_q != null) {
                        _q.remove(timedAction);
                    }
                }
            });
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

