/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public class OperatorTakeLastOne<T>
implements Observable.Operator<T, T> {
    public static <T> OperatorTakeLastOne<T> instance() {
        return Holder.INSTANCE;
    }

    private OperatorTakeLastOne() {
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final ParentSubscriber<? super T> parent = new ParentSubscriber<T>(child);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.requestMore(n);
            }
        });
        child.add(parent);
        return parent;
    }

    private static class ParentSubscriber<T>
    extends Subscriber<T> {
        private static final int NOT_REQUESTED_NOT_COMPLETED = 0;
        private static final int NOT_REQUESTED_COMPLETED = 1;
        private static final int REQUESTED_NOT_COMPLETED = 2;
        private static final int REQUESTED_COMPLETED = 3;
        private static final Object ABSENT = new Object();
        private final Subscriber<? super T> child;
        private T last = ABSENT;
        private final AtomicInteger state = new AtomicInteger(0);

        ParentSubscriber(Subscriber<? super T> child) {
            this.child = child;
        }

        void requestMore(long n) {
            if (n > 0L) {
                block3: {
                    while (true) {
                        int s;
                        if ((s = this.state.get()) == 0) {
                            if (!this.state.compareAndSet(0, 2)) continue;
                            return;
                        }
                        if (s != 1) break block3;
                        if (this.state.compareAndSet(1, 3)) break;
                    }
                    this.emit();
                    return;
                }
                return;
            }
        }

        @Override
        public void onCompleted() {
            block3: {
                if (this.last == ABSENT) {
                    this.child.onCompleted();
                    return;
                }
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 0) {
                        if (!this.state.compareAndSet(0, 1)) continue;
                        return;
                    }
                    if (s != 2) break block3;
                    if (this.state.compareAndSet(2, 3)) break;
                }
                this.emit();
                return;
            }
        }

        private void emit() {
            if (this.isUnsubscribed()) {
                this.last = null;
                return;
            }
            T t = this.last;
            this.last = null;
            if (t != ABSENT) {
                try {
                    this.child.onNext(t);
                }
                catch (Throwable e) {
                    this.child.onError(e);
                    return;
                }
            }
            if (!this.isUnsubscribed()) {
                this.child.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.last = t;
        }
    }

    private static class Holder {
        static final OperatorTakeLastOne<Object> INSTANCE = new OperatorTakeLastOne();

        private Holder() {
        }
    }
}

