/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.NotificationLite;
import rx.internal.producers.ProducerArbiter;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public final class OperatorMapNotification<T, R>
implements Observable.Operator<R, T> {
    final Func1<? super T, ? extends R> onNext;
    final Func1<? super Throwable, ? extends R> onError;
    final Func0<? extends R> onCompleted;

    public OperatorMapNotification(Func1<? super T, ? extends R> onNext, Func1<? super Throwable, ? extends R> onError, Func0<? extends R> onCompleted) {
        this.onNext = onNext;
        this.onError = onError;
        this.onCompleted = onCompleted;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> o) {
        ProducerArbiter pa = new ProducerArbiter();
        MapNotificationSubscriber subscriber = new MapNotificationSubscriber(pa, o);
        o.add(subscriber);
        subscriber.init();
        return subscriber;
    }

    static final class SingleEmitter<T>
    extends AtomicLong
    implements Producer,
    Subscription {
        private static final long serialVersionUID = -249869671366010660L;
        final NotificationLite<T> nl;
        final Subscriber<? super T> child;
        final Producer producer;
        final Subscription cancel;
        final Queue<Object> queue;
        volatile boolean complete;
        boolean emitting;
        boolean missed;

        public SingleEmitter(Subscriber<? super T> child, Producer producer, Subscription cancel) {
            this.child = child;
            this.producer = producer;
            this.cancel = cancel;
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue(2) : new ConcurrentLinkedQueue();
            this.nl = NotificationLite.instance();
        }

        @Override
        public void request(long n) {
            long u;
            long r;
            do {
                if ((r = this.get()) < 0L) {
                    return;
                }
                u = r + n;
                if (u >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.compareAndSet(r, u));
            this.producer.request(n);
            this.drain();
        }

        void produced(long n) {
            long u;
            long r;
            do {
                if ((r = this.get()) < 0L) {
                    return;
                }
                u = r - n;
                if (u >= 0L) continue;
                throw new IllegalStateException("More produced (" + n + ") than requested (" + r + ")");
            } while (!this.compareAndSet(r, u));
        }

        public void offer(T value) {
            if (!this.queue.offer(value)) {
                this.child.onError(new MissingBackpressureException());
                this.unsubscribe();
            } else {
                this.drain();
            }
        }

        public void offerAndComplete(T value) {
            if (!this.queue.offer(value)) {
                this.child.onError(new MissingBackpressureException());
                this.unsubscribe();
            } else {
                this.complete = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void drain() {
            SingleEmitter singleEmitter = this;
            // MONITORENTER : singleEmitter
            if (this.emitting) {
                this.missed = true;
                // MONITOREXIT : singleEmitter
                return;
            }
            this.emitting = true;
            this.missed = false;
            // MONITOREXIT : singleEmitter
            boolean skipFinal = false;
            while (true) {
                long r = this.get();
                boolean c = this.complete;
                boolean empty = this.queue.isEmpty();
                if (c && empty) {
                    this.child.onCompleted();
                    return;
                }
                if (r > 0L) {
                    Object v = this.queue.poll();
                    if (v != null) {
                        this.child.onNext(this.nl.getValue(v));
                        this.produced(1L);
                    } else if (c) {
                        this.child.onCompleted();
                        return;
                    }
                }
                SingleEmitter singleEmitter2 = this;
                // MONITORENTER : singleEmitter2
                if (this.missed) break block25;
                skipFinal = true;
                this.emitting = false;
                // MONITOREXIT : singleEmitter2
                if (skipFinal) return;
                SingleEmitter singleEmitter3 = this;
                break;
            }
            catch (Throwable throwable) {
                if (skipFinal) throw throwable;
                SingleEmitter singleEmitter4 = this;
                // MONITORENTER : singleEmitter4
                this.emitting = false;
                // MONITOREXIT : singleEmitter4
                throw throwable;
            }
            {
                block25: {
                    // MONITORENTER : singleEmitter3
                    this.emitting = false;
                    // MONITOREXIT : singleEmitter3
                    return;
                }
                this.missed = false;
                // MONITOREXIT : singleEmitter2
                continue;
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() < 0L;
        }

        @Override
        public void unsubscribe() {
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE) {
                this.cancel.unsubscribe();
            }
        }
    }

    final class MapNotificationSubscriber
    extends Subscriber<T> {
        private final Subscriber<? super R> o;
        private final ProducerArbiter pa;
        final SingleEmitter<R> emitter;

        MapNotificationSubscriber(ProducerArbiter pa, Subscriber<? super R> o) {
            this.pa = pa;
            this.o = o;
            this.emitter = new SingleEmitter(o, pa, this);
        }

        void init() {
            this.o.setProducer(this.emitter);
        }

        @Override
        public void setProducer(Producer producer) {
            this.pa.setProducer(producer);
        }

        @Override
        public void onCompleted() {
            try {
                this.emitter.offerAndComplete(OperatorMapNotification.this.onCompleted.call());
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, this.o);
            }
        }

        @Override
        public void onError(Throwable e) {
            try {
                this.emitter.offerAndComplete(OperatorMapNotification.this.onError.call(e));
            }
            catch (Throwable e2) {
                Exceptions.throwOrReport(e2, this.o);
            }
        }

        @Override
        public void onNext(T t) {
            try {
                this.emitter.offer(OperatorMapNotification.this.onNext.call(t));
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, this.o, t);
            }
        }
    }
}

