/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action0;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.atomic.SpscAtomicArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.TrampolineScheduler;

public final class OperatorObserveOn<T>
implements Observable.Operator<T, T> {
    private final Scheduler scheduler;
    private final boolean delayError;

    public OperatorObserveOn(Scheduler scheduler, boolean delayError) {
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        if (this.scheduler instanceof ImmediateScheduler) {
            return child;
        }
        if (this.scheduler instanceof TrampolineScheduler) {
            return child;
        }
        ObserveOnSubscriber<T> parent = new ObserveOnSubscriber<T>(this.scheduler, child, this.delayError);
        parent.init();
        return parent;
    }

    private static final class ObserveOnSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super T> child;
        final Scheduler.Worker recursiveScheduler;
        final NotificationLite<T> on;
        final boolean delayError;
        final Queue<Object> queue;
        volatile boolean finished;
        final AtomicLong requested = new AtomicLong();
        final AtomicLong counter = new AtomicLong();
        Throwable error;

        public ObserveOnSubscriber(Scheduler scheduler, Subscriber<? super T> child, boolean delayError) {
            this.child = child;
            this.recursiveScheduler = scheduler.createWorker();
            this.delayError = delayError;
            this.on = NotificationLite.instance();
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(RxRingBuffer.SIZE) : new SpscAtomicArrayQueue<Object>(RxRingBuffer.SIZE);
        }

        void init() {
            Subscriber<T> localChild = this.child;
            localChild.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        BackpressureUtils.getAndAddRequest(ObserveOnSubscriber.this.requested, n);
                        ObserveOnSubscriber.this.schedule();
                    }
                }
            });
            localChild.add(this.recursiveScheduler);
            localChild.add(this);
        }

        @Override
        public void onStart() {
            this.request(RxRingBuffer.SIZE);
        }

        @Override
        public void onNext(T t) {
            if (this.isUnsubscribed() || this.finished) {
                return;
            }
            if (!this.queue.offer(this.on.next(t))) {
                this.onError(new MissingBackpressureException());
                return;
            }
            this.schedule();
        }

        @Override
        public void onCompleted() {
            if (this.isUnsubscribed() || this.finished) {
                return;
            }
            this.finished = true;
            this.schedule();
        }

        @Override
        public void onError(Throwable e) {
            if (this.isUnsubscribed() || this.finished) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                return;
            }
            this.error = e;
            this.finished = true;
            this.schedule();
        }

        protected void schedule() {
            if (this.counter.getAndIncrement() == 0L) {
                this.recursiveScheduler.schedule(this);
            }
        }

        @Override
        public void call() {
            long emitted = 0L;
            long missed = 1L;
            Queue<Object> q = this.queue;
            Subscriber<T> localChild = this.child;
            NotificationLite<T> localOn = this.on;
            do {
                long requestAmount = this.requested.get();
                long currentEmission = 0L;
                while (requestAmount != currentEmission) {
                    boolean empty;
                    boolean done = this.finished;
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(done, empty, localChild, q)) {
                        return;
                    }
                    if (empty) break;
                    localChild.onNext(localOn.getValue(v));
                    ++currentEmission;
                    ++emitted;
                }
                if (requestAmount == currentEmission && this.checkTerminated(this.finished, q.isEmpty(), localChild, q)) {
                    return;
                }
                if (currentEmission == 0L) continue;
                BackpressureUtils.produced(this.requested, currentEmission);
            } while ((missed = this.counter.addAndGet(-missed)) != 0L);
            if (emitted != 0L) {
                this.request(emitted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkTerminated(boolean done, boolean isEmpty, Subscriber<? super T> a, Queue<Object> q) {
            if (a.isUnsubscribed()) {
                q.clear();
                return true;
            }
            if (done) {
                if (this.delayError) {
                    if (isEmpty) {
                        Throwable e = this.error;
                        try {
                            if (e != null) {
                                a.onError(e);
                            }
                            a.onCompleted();
                        }
                        finally {
                            this.recursiveScheduler.unsubscribe();
                        }
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        q.clear();
                        try {
                            a.onError(e);
                        }
                        finally {
                            this.recursiveScheduler.unsubscribe();
                        }
                        return true;
                    }
                    if (isEmpty) {
                        try {
                            a.onCompleted();
                        }
                        finally {
                            this.recursiveScheduler.unsubscribe();
                        }
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

