/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Completable;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.SingleEmitter;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.Subscription;
import rx.annotations.Beta;
import rx.annotations.Experimental;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Actions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.functions.FuncN;
import rx.internal.observers.AssertableSubscriberObservable;
import rx.internal.operators.CompletableFlatMapSingleToCompletable;
import rx.internal.operators.SingleDelay;
import rx.internal.operators.SingleDoAfterTerminate;
import rx.internal.operators.SingleDoOnEvent;
import rx.internal.operators.SingleDoOnSubscribe;
import rx.internal.operators.SingleDoOnUnsubscribe;
import rx.internal.operators.SingleFromCallable;
import rx.internal.operators.SingleFromEmitter;
import rx.internal.operators.SingleFromFuture;
import rx.internal.operators.SingleFromObservable;
import rx.internal.operators.SingleLiftObservableOperator;
import rx.internal.operators.SingleObserveOn;
import rx.internal.operators.SingleOnErrorReturn;
import rx.internal.operators.SingleOnSubscribeDelaySubscriptionOther;
import rx.internal.operators.SingleOnSubscribeMap;
import rx.internal.operators.SingleOnSubscribeUsing;
import rx.internal.operators.SingleOperatorOnErrorResumeNext;
import rx.internal.operators.SingleOperatorZip;
import rx.internal.operators.SingleTakeUntilCompletable;
import rx.internal.operators.SingleTakeUntilObservable;
import rx.internal.operators.SingleTakeUntilSingle;
import rx.internal.operators.SingleTimeout;
import rx.internal.operators.SingleToObservable;
import rx.internal.util.ScalarSynchronousSingle;
import rx.internal.util.UtilityFunctions;
import rx.observers.AssertableSubscriber;
import rx.observers.SafeSubscriber;
import rx.plugins.RxJavaHooks;
import rx.schedulers.Schedulers;
import rx.singles.BlockingSingle;
import rx.subscriptions.Subscriptions;

public class Single<T> {
    final OnSubscribe<T> onSubscribe;

    protected Single(OnSubscribe<T> f) {
        this.onSubscribe = RxJavaHooks.onCreate(f);
    }

    @Deprecated
    protected Single(Observable.OnSubscribe<T> f) {
        this.onSubscribe = RxJavaHooks.onCreate(new SingleFromObservable<T>(f));
    }

    public static <T> Single<T> create(OnSubscribe<T> f) {
        return new Single<T>(f);
    }

    @Beta
    public final <R> Single<R> lift(Observable.Operator<? extends R, ? super T> lift) {
        return Single.create(new SingleLiftObservableOperator<T, R>(this.onSubscribe, lift));
    }

    public <R> Single<R> compose(Transformer<? super T, ? extends R> transformer) {
        return (Single)transformer.call(this);
    }

    private static <T> Observable<T> asObservable(Single<T> t) {
        return Observable.unsafeCreate(new SingleToObservable<T>(t.onSubscribe));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8));
    }

    public static <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8, Single<? extends T> t9) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8), Single.asObservable(t9));
    }

    public static <T> Single<T> error(final Throwable exception) {
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(SingleSubscriber<? super T> te) {
                te.onError(exception);
            }
        });
    }

    public static <T> Single<T> from(Future<? extends T> future) {
        return Single.create(new SingleFromFuture<T>(future, 0L, null));
    }

    public static <T> Single<T> from(Future<? extends T> future, long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit is null");
        }
        return Single.create(new SingleFromFuture<T>(future, timeout, unit));
    }

    public static <T> Single<T> from(Future<? extends T> future, Scheduler scheduler) {
        return Single.from(future).subscribeOn(scheduler);
    }

    public static <T> Single<T> fromCallable(Callable<? extends T> func) {
        return Single.create(new SingleFromCallable<T>(func));
    }

    @Experimental
    public static <T> Single<T> fromEmitter(Action1<SingleEmitter<T>> producer) {
        if (producer == null) {
            throw new NullPointerException("producer is null");
        }
        return Single.create(new SingleFromEmitter<T>(producer));
    }

    public static <T> Single<T> just(T value) {
        return ScalarSynchronousSingle.create(value);
    }

    public static <T> Single<T> merge(final Single<? extends Single<? extends T>> source) {
        if (source instanceof ScalarSynchronousSingle) {
            return ((ScalarSynchronousSingle)source).scalarFlatMap(UtilityFunctions.identity());
        }
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(final SingleSubscriber<? super T> child) {
                SingleSubscriber parent = new SingleSubscriber<Single<? extends T>>(){

                    @Override
                    public void onSuccess(Single<? extends T> innerSingle) {
                        innerSingle.subscribe(child);
                    }

                    @Override
                    public void onError(Throwable error) {
                        child.onError(error);
                    }
                };
                child.add(parent);
                source.subscribe(parent);
            }
        });
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2));
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3));
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4));
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5));
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6));
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7));
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8));
    }

    public static <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8, Single<? extends T> t9) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8), Single.asObservable(t9));
    }

    @Experimental
    public static <T> Observable<T> merge(Observable<? extends Single<? extends T>> sources) {
        return Single.merge(sources, Integer.MAX_VALUE);
    }

    @Experimental
    public static <T> Observable<T> merge(Observable<? extends Single<? extends T>> sources, int maxConcurrency) {
        return sources.flatMapSingle(UtilityFunctions.identity(), false, maxConcurrency);
    }

    @Experimental
    public static <T> Observable<T> mergeDelayError(Observable<? extends Single<? extends T>> sources) {
        return Single.merge(sources, Integer.MAX_VALUE);
    }

    @Experimental
    public static <T> Observable<T> mergeDelayError(Observable<? extends Single<? extends T>> sources, int maxConcurrency) {
        return sources.flatMapSingle(UtilityFunctions.identity(), true, maxConcurrency);
    }

    public static <T1, T2, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, final Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1]);
            }
        });
    }

    public static <T1, T2, T3, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, final Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2, s3}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1], args[2]);
            }
        });
    }

    public static <T1, T2, T3, T4, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Single<? extends T4> s4, final Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2, s3, s4}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1], args[2], args[3]);
            }
        });
    }

    public static <T1, T2, T3, T4, T5, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Single<? extends T4> s4, Single<? extends T5> s5, final Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2, s3, s4, s5}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1], args[2], args[3], args[4]);
            }
        });
    }

    public static <T1, T2, T3, T4, T5, T6, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Single<? extends T4> s4, Single<? extends T5> s5, Single<? extends T6> s6, final Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2, s3, s4, s5, s6}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1], args[2], args[3], args[4], args[5]);
            }
        });
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Single<? extends T4> s4, Single<? extends T5> s5, Single<? extends T6> s6, Single<? extends T7> s7, final Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2, s3, s4, s5, s6, s7}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        });
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Single<? extends T4> s4, Single<? extends T5> s5, Single<? extends T6> s6, Single<? extends T7> s7, Single<? extends T8> s8, final Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2, s3, s4, s5, s6, s7, s8}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }
        });
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Single<? extends T4> s4, Single<? extends T5> s5, Single<? extends T6> s6, Single<? extends T7> s7, Single<? extends T8> s8, Single<? extends T9> s9, final Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        return SingleOperatorZip.zip(new Single[]{s1, s2, s3, s4, s5, s6, s7, s8, s9}, new FuncN<R>(){

            @Override
            public R call(Object ... args) {
                return zipFunction.call(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
            }
        });
    }

    public static <R> Single<R> zip(Iterable<? extends Single<?>> singles, FuncN<? extends R> zipFunction) {
        Single<T>[] iterableToArray = Single.iterableToArray(singles);
        return SingleOperatorZip.zip(iterableToArray, zipFunction);
    }

    @Experimental
    public final Single<T> cache() {
        return this.toObservable().cacheWithInitialCapacity(1).toSingle();
    }

    public final Observable<T> concatWith(Single<? extends T> t1) {
        return Single.concat(this, t1);
    }

    public final <R> Single<R> flatMap(Func1<? super T, ? extends Single<? extends R>> func) {
        if (this instanceof ScalarSynchronousSingle) {
            return ((ScalarSynchronousSingle)this).scalarFlatMap(func);
        }
        return Single.merge(this.map(func));
    }

    public final <R> Observable<R> flatMapObservable(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.merge(Single.asObservable(this.map(func)));
    }

    @Beta
    public final Completable flatMapCompletable(Func1<? super T, ? extends Completable> func) {
        return Completable.create(new CompletableFlatMapSingleToCompletable<T>(this, func));
    }

    public final <R> Single<R> map(Func1<? super T, ? extends R> func) {
        return Single.create(new SingleOnSubscribeMap<T, R>(this, func));
    }

    public final Observable<T> mergeWith(Single<? extends T> t1) {
        return Single.merge(this, t1);
    }

    public final Single<T> observeOn(Scheduler scheduler) {
        if (this instanceof ScalarSynchronousSingle) {
            return ((ScalarSynchronousSingle)this).scalarScheduleOn(scheduler);
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is null");
        }
        return Single.create(new SingleObserveOn<T>(this.onSubscribe, scheduler));
    }

    public final Single<T> onErrorReturn(Func1<Throwable, ? extends T> resumeFunction) {
        return Single.create(new SingleOnErrorReturn<T>(this.onSubscribe, resumeFunction));
    }

    @Beta
    public final Single<T> onErrorResumeNext(Single<? extends T> resumeSingleInCaseOfError) {
        return new Single<T>(SingleOperatorOnErrorResumeNext.withOther(this, resumeSingleInCaseOfError));
    }

    @Beta
    public final Single<T> onErrorResumeNext(Func1<Throwable, ? extends Single<? extends T>> resumeFunctionInCaseOfError) {
        return new Single(SingleOperatorOnErrorResumeNext.withFunction(this, resumeFunctionInCaseOfError));
    }

    public final Subscription subscribe() {
        return this.subscribe(Actions.empty(), Actions.errorNotImplemented());
    }

    public final Subscription subscribe(Action1<? super T> onSuccess) {
        return this.subscribe(onSuccess, Actions.errorNotImplemented());
    }

    public final Subscription subscribe(final Action1<? super T> onSuccess, final Action1<Throwable> onError) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return this.subscribe(new SingleSubscriber<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void onError(Throwable e) {
                try {
                    onError.call(e);
                }
                finally {
                    this.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void onSuccess(T args) {
                try {
                    onSuccess.call(args);
                }
                finally {
                    this.unsubscribe();
                }
            }
        });
    }

    public final Subscription unsafeSubscribe(Subscriber<? super T> subscriber) {
        return this.unsafeSubscribe(subscriber, true);
    }

    private Subscription unsafeSubscribe(Subscriber<? super T> subscriber, boolean start) {
        try {
            if (start) {
                subscriber.onStart();
            }
            RxJavaHooks.onSingleStart(this, this.onSubscribe).call(SingleLiftObservableOperator.wrap(subscriber));
            return RxJavaHooks.onSingleReturn(subscriber);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                subscriber.onError(RxJavaHooks.onSingleError(e));
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RuntimeException r = new RuntimeException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                RxJavaHooks.onSingleError(r);
                throw r;
            }
            return Subscriptions.unsubscribed();
        }
    }

    public final Subscription subscribe(final Observer<? super T> observer) {
        if (observer == null) {
            throw new NullPointerException("observer is null");
        }
        return this.subscribe(new SingleSubscriber<T>(){

            @Override
            public void onSuccess(T value) {
                observer.onNext(value);
                observer.onCompleted();
            }

            @Override
            public void onError(Throwable error) {
                observer.onError(error);
            }
        });
    }

    public final Subscription subscribe(Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("observer can not be null");
        }
        subscriber.onStart();
        if (!(subscriber instanceof SafeSubscriber)) {
            return this.unsafeSubscribe(new SafeSubscriber<T>(subscriber), false);
        }
        return this.unsafeSubscribe(subscriber, true);
    }

    public final Subscription subscribe(SingleSubscriber<? super T> te) {
        if (te == null) {
            throw new IllegalArgumentException("te is null");
        }
        try {
            RxJavaHooks.onSingleStart(this, this.onSubscribe).call(te);
            return RxJavaHooks.onSingleReturn(te);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            try {
                te.onError(RxJavaHooks.onSingleError(ex));
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RuntimeException r = new RuntimeException("Error occurred attempting to subscribe [" + ex.getMessage() + "] and then again while trying to pass to onError.", e2);
                RxJavaHooks.onSingleError(r);
                throw r;
            }
            return Subscriptions.empty();
        }
    }

    public final Single<T> subscribeOn(final Scheduler scheduler) {
        if (this instanceof ScalarSynchronousSingle) {
            return ((ScalarSynchronousSingle)this).scalarScheduleOn(scheduler);
        }
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(final SingleSubscriber<? super T> t) {
                final Scheduler.Worker w = scheduler.createWorker();
                t.add(w);
                w.schedule(new Action0(){

                    @Override
                    public void call() {
                        SingleSubscriber single = new SingleSubscriber<T>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onSuccess(T value) {
                                try {
                                    t.onSuccess(value);
                                }
                                finally {
                                    w.unsubscribe();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onError(Throwable error) {
                                try {
                                    t.onError(error);
                                }
                                finally {
                                    w.unsubscribe();
                                }
                            }
                        };
                        t.add(single);
                        Single.this.subscribe(single);
                    }
                });
            }
        });
    }

    public final Single<T> takeUntil(Completable other) {
        return Single.create(new SingleTakeUntilCompletable<T>(this.onSubscribe, other));
    }

    public final <E> Single<T> takeUntil(Observable<? extends E> other) {
        return Single.create(new SingleTakeUntilObservable<T, E>(this.onSubscribe, other));
    }

    public final <E> Single<T> takeUntil(Single<? extends E> other) {
        return Single.create(new SingleTakeUntilSingle<T, E>(this.onSubscribe, other));
    }

    @Experimental
    public final <R> R to(Func1<? super Single<T>, R> converter) {
        return converter.call(this);
    }

    public final Observable<T> toObservable() {
        return Single.asObservable(this);
    }

    @Beta
    public final Completable toCompletable() {
        return Completable.fromSingle(this);
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit) {
        return this.timeout(timeout, timeUnit, null, Schedulers.computation());
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return this.timeout(timeout, timeUnit, null, scheduler);
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit, Single<? extends T> other) {
        return this.timeout(timeout, timeUnit, other, Schedulers.computation());
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit, Single<? extends T> other, Scheduler scheduler) {
        if (other == null) {
            other = Single.error(new TimeoutException());
        }
        return Single.create(new SingleTimeout<T>(this.onSubscribe, timeout, timeUnit, scheduler, other.onSubscribe));
    }

    @Beta
    public final BlockingSingle<T> toBlocking() {
        return BlockingSingle.from(this);
    }

    public final <T2, R> Single<R> zipWith(Single<? extends T2> other, Func2<? super T, ? super T2, ? extends R> zipFunction) {
        return Single.zip(this, other, zipFunction);
    }

    @Beta
    public final Single<T> doOnError(final Action1<Throwable> onError) {
        if (onError == null) {
            throw new IllegalArgumentException("onError is null");
        }
        return Single.create(new SingleDoOnEvent(this, Actions.empty(), new Action1<Throwable>(){

            @Override
            public void call(Throwable throwable) {
                onError.call(throwable);
            }
        }));
    }

    @Experimental
    public final Single<T> doOnEach(final Action1<Notification<? extends T>> onNotification) {
        if (onNotification == null) {
            throw new IllegalArgumentException("onNotification is null");
        }
        return Single.create(new SingleDoOnEvent(this, new Action1<T>(){

            @Override
            public void call(T t) {
                onNotification.call(Notification.createOnNext(t));
            }
        }, new Action1<Throwable>(){

            @Override
            public void call(Throwable throwable) {
                onNotification.call(Notification.createOnError(throwable));
            }
        }));
    }

    @Experimental
    public final Single<T> doOnSuccess(Action1<? super T> onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess is null");
        }
        Actions.EmptyAction empty = Actions.empty();
        return Single.create(new SingleDoOnEvent<T>(this, onSuccess, empty));
    }

    @Beta
    public final Single<T> doOnSubscribe(Action0 subscribe) {
        return Single.create(new SingleDoOnSubscribe<T>(this.onSubscribe, subscribe));
    }

    @Beta
    public final Single<T> delay(long delay, TimeUnit unit, Scheduler scheduler) {
        return Single.create(new SingleDelay<T>(this.onSubscribe, delay, unit, scheduler));
    }

    @Beta
    public final Single<T> delay(long delay, TimeUnit unit) {
        return this.delay(delay, unit, Schedulers.computation());
    }

    @Beta
    public static <T> Single<T> defer(final Callable<Single<T>> singleFactory) {
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(SingleSubscriber<? super T> singleSubscriber) {
                Single single;
                try {
                    single = (Single)singleFactory.call();
                }
                catch (Throwable t) {
                    Exceptions.throwIfFatal(t);
                    singleSubscriber.onError(t);
                    return;
                }
                single.subscribe(singleSubscriber);
            }
        });
    }

    @Beta
    public final Single<T> doOnUnsubscribe(Action0 action) {
        return Single.create(new SingleDoOnUnsubscribe<T>(this.onSubscribe, action));
    }

    @Beta
    public final Single<T> doAfterTerminate(Action0 action) {
        return Single.create(new SingleDoAfterTerminate(this, action));
    }

    static <T> Single<? extends T>[] iterableToArray(Iterable<? extends Single<? extends T>> singlesIterable) {
        Single[] singlesArray;
        if (singlesIterable instanceof Collection) {
            Collection list = (Collection)singlesIterable;
            int count = list.size();
            singlesArray = list.toArray(new Single[count]);
        } else {
            Single[] tempArray = new Single[8];
            int count = 0;
            for (Single<T> single : singlesIterable) {
                if (count == tempArray.length) {
                    Single[] sb = new Single[count + (count >> 2)];
                    System.arraycopy(tempArray, 0, sb, 0, count);
                    tempArray = sb;
                }
                tempArray[count] = single;
                ++count;
            }
            if (tempArray.length == count) {
                singlesArray = tempArray;
            } else {
                singlesArray = new Single[count];
                System.arraycopy(tempArray, 0, singlesArray, 0, count);
            }
        }
        return singlesArray;
    }

    public final Single<T> retry() {
        return this.toObservable().retry().toSingle();
    }

    public final Single<T> retry(long count) {
        return this.toObservable().retry(count).toSingle();
    }

    public final Single<T> retry(Func2<Integer, Throwable, Boolean> predicate) {
        return this.toObservable().retry(predicate).toSingle();
    }

    public final Single<T> retryWhen(Func1<Observable<? extends Throwable>, ? extends Observable<?>> notificationHandler) {
        return this.toObservable().retryWhen(notificationHandler).toSingle();
    }

    @Beta
    public static <T, Resource> Single<T> using(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Single<? extends T>> singleFactory, Action1<? super Resource> disposeAction) {
        return Single.using(resourceFactory, singleFactory, disposeAction, false);
    }

    @Beta
    public static <T, Resource> Single<T> using(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Single<? extends T>> singleFactory, Action1<? super Resource> disposeAction, boolean disposeEagerly) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory is null");
        }
        if (singleFactory == null) {
            throw new NullPointerException("singleFactory is null");
        }
        if (disposeAction == null) {
            throw new NullPointerException("disposeAction is null");
        }
        return Single.create(new SingleOnSubscribeUsing(resourceFactory, singleFactory, disposeAction, disposeEagerly));
    }

    @Beta
    public final Single<T> delaySubscription(Observable<?> other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return Single.create(new SingleOnSubscribeDelaySubscriptionOther(this, other));
    }

    @Experimental
    public final Single<T> unsubscribeOn(final Scheduler scheduler) {
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(final SingleSubscriber<? super T> t) {
                final SingleSubscriber single = new SingleSubscriber<T>(){

                    @Override
                    public void onSuccess(T value) {
                        t.onSuccess(value);
                    }

                    @Override
                    public void onError(Throwable error) {
                        t.onError(error);
                    }
                };
                t.add(Subscriptions.create(new Action0(){

                    @Override
                    public void call() {
                        final Scheduler.Worker w = scheduler.createWorker();
                        w.schedule(new Action0(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void call() {
                                try {
                                    single.unsubscribe();
                                }
                                finally {
                                    w.unsubscribe();
                                }
                            }
                        });
                    }
                }));
                Single.this.subscribe(single);
            }
        });
    }

    @Experimental
    public final AssertableSubscriber<T> test() {
        AssertableSubscriberObservable ts = AssertableSubscriberObservable.create(Long.MAX_VALUE);
        this.subscribe(ts);
        return ts;
    }

    public static interface Transformer<T, R>
    extends Func1<Single<T>, Single<R>> {
    }

    public static interface OnSubscribe<T>
    extends Action1<SingleSubscriber<? super T>> {
    }
}

