/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class SerialDisposable
implements Disposable {
    final AtomicReference<Disposable> resource;

    public SerialDisposable() {
        this.resource = new AtomicReference();
    }

    public SerialDisposable(Disposable initialDisposable) {
        this.resource = new AtomicReference<Disposable>(initialDisposable);
    }

    public boolean set(Disposable next) {
        return DisposableHelper.set(this.resource, next);
    }

    public boolean replace(Disposable next) {
        return DisposableHelper.replace(this.resource, next);
    }

    public Disposable get() {
        Disposable d = this.resource.get();
        if (d == DisposableHelper.DISPOSED) {
            return Disposables.disposed();
        }
        return d;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.resource);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed(this.get());
    }
}

