/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.completable.CompletableMerge;
import io.reactivex.internal.queue.MpscLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeDelayErrorArray
extends Completable {
    final CompletableSource[] sources;

    public CompletableMergeDelayErrorArray(CompletableSource[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(final CompletableObserver s) {
        final CompositeDisposable set = new CompositeDisposable();
        final AtomicInteger wip = new AtomicInteger(this.sources.length + 1);
        final MpscLinkedQueue<Throwable> q = new MpscLinkedQueue<Throwable>();
        s.onSubscribe(set);
        for (CompletableSource c : this.sources) {
            if (set.isDisposed()) {
                return;
            }
            if (c == null) {
                q.offer(new NullPointerException("A completable source is null"));
                wip.decrementAndGet();
                continue;
            }
            c.subscribe(new CompletableObserver(){

                @Override
                public void onSubscribe(Disposable d) {
                    set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    q.offer(e);
                    this.tryTerminate();
                }

                @Override
                public void onComplete() {
                    this.tryTerminate();
                }

                void tryTerminate() {
                    if (wip.decrementAndGet() == 0) {
                        if (q.isEmpty()) {
                            s.onComplete();
                        } else {
                            s.onError(CompletableMerge.collectErrors(q));
                        }
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0) {
            if (q.isEmpty()) {
                s.onComplete();
            } else {
                s.onError(CompletableMerge.collectErrors(q));
            }
        }
    }
}

