/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CompletableUsing<R>
extends Completable {
    final Callable<R> resourceSupplier;
    final Function<? super R, ? extends CompletableSource> completableFunction;
    final Consumer<? super R> disposer;
    final boolean eager;

    public CompletableUsing(Callable<R> resourceSupplier, Function<? super R, ? extends CompletableSource> completableFunction, Consumer<? super R> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.completableFunction = completableFunction;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s) {
        CompletableSource cs;
        R resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, s);
            return;
        }
        try {
            cs = ObjectHelper.requireNonNull(this.completableFunction.apply(resource), "The completableFunction returned a null Completable");
        }
        catch (Throwable e2) {
            CompositeException e2;
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                e2 = new CompositeException(e2, ex);
            }
            EmptyDisposable.error((Throwable)e2, s);
            return;
        }
        final AtomicBoolean once = new AtomicBoolean();
        cs.subscribe(new CompletableObserver(){
            Disposable d;

            void disposeThis() {
                this.d.dispose();
                if (once.compareAndSet(false, true)) {
                    try {
                        CompletableUsing.this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        RxJavaPlugins.onError(ex);
                    }
                }
            }

            @Override
            public void onComplete() {
                if (CompletableUsing.this.eager && once.compareAndSet(false, true)) {
                    try {
                        CompletableUsing.this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        s.onError(ex);
                        return;
                    }
                }
                s.onComplete();
                if (!CompletableUsing.this.eager) {
                    this.disposeThis();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (CompletableUsing.this.eager && once.compareAndSet(false, true)) {
                    try {
                        CompletableUsing.this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        e = new CompositeException(ex, e);
                    }
                }
                s.onError(e);
                if (!CompletableUsing.this.eager) {
                    this.disposeThis();
                }
            }

            @Override
            public void onSubscribe(Disposable d) {
                this.d = d;
                s.onSubscribe(Disposables.from(new Runnable(){

                    @Override
                    public void run() {
                        this.disposeThis();
                    }
                }));
            }
        });
    }
}

