/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class BlockingFlowableIterator<T>
extends AtomicReference<Subscription>
implements Subscriber<T>,
Iterator<T>,
Runnable,
Disposable {
    private static final long serialVersionUID = 6695226475494099826L;
    final SpscLinkedArrayQueue<T> queue;
    final long batchSize;
    final long limit;
    final Lock lock;
    final Condition condition;
    long produced;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;

    public BlockingFlowableIterator(int batchSize) {
        this.queue = new SpscLinkedArrayQueue(batchSize);
        this.batchSize = batchSize;
        this.limit = batchSize - (batchSize >> 2);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    @Override
    public boolean hasNext() {
        block5: while (true) {
            if (this.cancelled) {
                return false;
            }
            boolean d = this.done;
            boolean empty = this.queue.isEmpty();
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    throw Exceptions.propagate(e);
                }
                if (empty) {
                    return false;
                }
            }
            if (!empty) break;
            this.lock.lock();
            try {
                while (true) {
                    if (this.cancelled || this.done || !this.queue.isEmpty()) continue block5;
                    this.condition.await();
                }
            }
            catch (InterruptedException ex) {
                this.run();
                throw Exceptions.propagate(ex);
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T v = this.queue.poll();
            if (v == null) {
                this.run();
                throw new IllegalStateException("Queue empty?!");
            }
            long p = this.produced + 1L;
            if (p == this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
            return v;
        }
        throw new NoSuchElementException();
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this, s)) {
            s.request(this.batchSize);
        }
    }

    public void onNext(T t) {
        if (!this.queue.offer(t)) {
            SubscriptionHelper.cancel(this);
            this.onError(new IllegalStateException("Queue full?!"));
        } else {
            this.signalConsumer();
        }
    }

    public void onError(Throwable t) {
        this.error = t;
        this.done = true;
        this.signalConsumer();
    }

    public void onComplete() {
        this.done = true;
        this.signalConsumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalConsumer() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        SubscriptionHelper.cancel(this);
        this.signalConsumer();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this);
    }

    @Override
    public boolean isDisposed() {
        return SubscriptionHelper.isCancelled((Subscription)this.get());
    }
}

