/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.subscribers.DisposableSubscriber;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;

public enum BlockingFlowableNext {


    public static <T> Iterable<T> next(final Publisher<? extends T> items) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                NextObserver nextObserver = new NextObserver();
                return new NextIterator(items, nextObserver);
            }
        };
    }

    static final class NextObserver<T>
    extends DisposableSubscriber<Notification<T>> {
        private final BlockingQueue<Notification<T>> buf = new ArrayBlockingQueue<Notification<T>>(1);
        final AtomicInteger waiting = new AtomicInteger();

        NextObserver() {
        }

        public void onComplete() {
        }

        public void onError(Throwable e) {
        }

        public void onNext(Notification<T> args) {
            if (this.waiting.getAndSet(0) == 1 || !args.isOnNext()) {
                Notification toOffer = args;
                while (!this.buf.offer(toOffer)) {
                    Notification concurrentItem = (Notification)this.buf.poll();
                    if (concurrentItem == null || concurrentItem.isOnNext()) continue;
                    toOffer = concurrentItem;
                }
            }
        }

        public Notification<T> takeNext() throws InterruptedException {
            this.setWaiting();
            return this.buf.take();
        }

        void setWaiting() {
            this.waiting.set(1);
        }
    }

    static final class NextIterator<T>
    implements Iterator<T> {
        private final NextObserver<T> observer;
        private final Publisher<? extends T> items;
        private T next;
        private boolean hasNext = true;
        private boolean isNextConsumed = true;
        private Throwable error;
        private boolean started;

        NextIterator(Publisher<? extends T> items, NextObserver<T> observer) {
            this.items = items;
            this.observer = observer;
        }

        @Override
        public boolean hasNext() {
            if (this.error != null) {
                throw Exceptions.propagate(this.error);
            }
            if (!this.hasNext) {
                return false;
            }
            return !this.isNextConsumed || this.moveToNext();
        }

        private boolean moveToNext() {
            try {
                Notification<T> nextNotification;
                if (!this.started) {
                    this.started = true;
                    this.observer.setWaiting();
                    Flowable.fromPublisher(this.items).materialize().subscribe(this.observer);
                }
                if ((nextNotification = this.observer.takeNext()).isOnNext()) {
                    this.isNextConsumed = false;
                    this.next = nextNotification.getValue();
                    return true;
                }
                this.hasNext = false;
                if (nextNotification.isOnComplete()) {
                    return false;
                }
                if (nextNotification.isOnError()) {
                    this.error = nextNotification.getError();
                    throw Exceptions.propagate(this.error);
                }
                throw new IllegalStateException("Should not reach here");
            }
            catch (InterruptedException e) {
                this.observer.dispose();
                Thread.currentThread().interrupt();
                this.error = e;
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public T next() {
            if (this.error != null) {
                throw Exceptions.propagate(this.error);
            }
            if (this.hasNext()) {
                this.isNextConsumed = true;
                return this.next;
            }
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read only iterator");
        }
    }
}

