/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableIntervalRange
extends Flowable<Long> {
    final Scheduler scheduler;
    final long start;
    final long end;
    final long initialDelay;
    final long period;
    final TimeUnit unit;

    public FlowableIntervalRange(long start, long end, long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
        this.start = start;
        this.end = end;
    }

    @Override
    public void subscribeActual(Subscriber<? super Long> s) {
        IntervalRangeSubscriber is = new IntervalRangeSubscriber(s, this.start, this.end);
        s.onSubscribe((Subscription)is);
        Disposable d = this.scheduler.schedulePeriodicallyDirect(is, this.initialDelay, this.period, this.unit);
        is.setResource(d);
    }

    static final class IntervalRangeSubscriber
    extends AtomicLong
    implements Subscription,
    Runnable {
        private static final long serialVersionUID = -2809475196591179431L;
        final Subscriber<? super Long> actual;
        final long end;
        long count;
        final AtomicReference<Disposable> resource = new AtomicReference();

        public IntervalRangeSubscriber(Subscriber<? super Long> actual, long start, long end) {
            this.actual = actual;
            this.count = start;
            this.end = end;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        public void cancel() {
            DisposableHelper.dispose(this.resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.resource.get() != DisposableHelper.DISPOSED) {
                long r = this.get();
                if (r != 0L) {
                    long c = this.count;
                    this.actual.onNext((Object)c);
                    if (c == this.end) {
                        try {
                            this.actual.onComplete();
                        }
                        finally {
                            DisposableHelper.dispose(this.resource);
                        }
                        return;
                    }
                    this.count = c + 1L;
                    if (r != Long.MAX_VALUE) {
                        this.decrementAndGet();
                    }
                } else {
                    try {
                        this.actual.onError((Throwable)new IllegalStateException("Can't deliver value " + this.count + " due to lack of requests"));
                    }
                    finally {
                        DisposableHelper.dispose(this.resource);
                    }
                }
            }
        }

        public void setResource(Disposable d) {
            DisposableHelper.setOnce(this.resource, d);
        }
    }
}

