/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Notification;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableMaterialize<T>
extends AbstractObservableWithUpstream<T, Notification<T>> {
    public ObservableMaterialize(ObservableSource<T> source) {
        super(source);
    }

    @Override
    public void subscribeActual(Observer<? super Notification<T>> t) {
        this.source.subscribe(new MaterializeSubscriber(t));
    }

    static final class MaterializeSubscriber<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super Notification<T>> actual;
        Disposable s;
        volatile boolean done;

        public MaterializeSubscriber(Observer<? super Notification<T>> actual) {
            this.actual = actual;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(Notification.createOnNext(t));
        }

        @Override
        public void onError(Throwable t) {
            Notification v = Notification.createOnError(t);
            this.actual.onNext(v);
            this.actual.onComplete();
        }

        @Override
        public void onComplete() {
            Notification v = Notification.createOnComplete();
            this.actual.onNext(v);
            this.actual.onComplete();
        }
    }
}

