/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.subscribers.observable.ToNotificationObserver;
import io.reactivex.subjects.BehaviorSubject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableRedo<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Observable<Notification<Object>>, ? extends ObservableSource<?>> manager;

    public ObservableRedo(ObservableSource<T> source, Function<? super Observable<Notification<Object>>, ? extends ObservableSource<?>> manager) {
        super(source);
        this.manager = manager;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        ObservableSource<?> action;
        BehaviorSubject<Notification<Object>> subject = BehaviorSubject.create();
        final RedoSubscriber<T> parent = new RedoSubscriber<T>(s, subject, this.source);
        s.onSubscribe(parent.arbiter);
        try {
            action = this.manager.apply(subject);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            s.onError(ex);
            return;
        }
        action.subscribe(new ToNotificationObserver((Consumer<? super Notification<Object>>)new Consumer<Notification<Object>>(){

            @Override
            public void accept(Notification<Object> o) {
                parent.handle(o);
            }
        }));
        parent.handle(Notification.createOnNext(0));
    }

    static final class RedoSubscriber<T>
    extends AtomicBoolean
    implements Observer<T> {
        private static final long serialVersionUID = -1151903143112844287L;
        final Observer<? super T> actual;
        final BehaviorSubject<Notification<Object>> subject;
        final ObservableSource<? extends T> source;
        final SequentialDisposable arbiter;
        final AtomicInteger wip = new AtomicInteger();

        public RedoSubscriber(Observer<? super T> actual, BehaviorSubject<Notification<Object>> subject, ObservableSource<? extends T> source) {
            this.actual = actual;
            this.subject = subject;
            this.source = source;
            this.arbiter = new SequentialDisposable();
            this.lazySet(true);
        }

        @Override
        public void onSubscribe(Disposable s) {
            this.arbiter.replace(s);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.compareAndSet(false, true)) {
                this.subject.onNext(Notification.createOnError(t));
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.subject.onNext(Notification.createOnComplete());
            }
        }

        void handle(Notification<Object> notification) {
            if (this.compareAndSet(true, false)) {
                if (notification.isOnError()) {
                    this.arbiter.dispose();
                    this.actual.onError(notification.getError());
                } else if (notification.isOnNext()) {
                    if (this.wip.getAndIncrement() == 0) {
                        int missed = 1;
                        do {
                            if (this.arbiter.isDisposed()) {
                                return;
                            }
                            this.source.subscribe(this);
                        } while ((missed = this.wip.addAndGet(-missed)) != 0);
                    }
                } else {
                    this.arbiter.dispose();
                    this.actual.onComplete();
                }
            }
        }
    }
}

