/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observables.ConnectableObservable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class ObservableRefCount<T>
extends AbstractObservableWithUpstream<T, T> {
    final ConnectableObservable<? extends T> source;
    volatile CompositeDisposable baseSubscription = new CompositeDisposable();
    final AtomicInteger subscriptionCount = new AtomicInteger();
    final ReentrantLock lock = new ReentrantLock();

    public ObservableRefCount(ConnectableObservable<T> source) {
        super(source);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeActual(Observer<? super T> subscriber) {
        this.lock.lock();
        if (this.subscriptionCount.incrementAndGet() == 1) {
            AtomicBoolean writeLocked = new AtomicBoolean(true);
            try {
                this.source.connect(this.onSubscribe(subscriber, writeLocked));
            }
            finally {
                if (writeLocked.get()) {
                    this.lock.unlock();
                }
            }
        }
        try {
            this.doSubscribe(subscriber, this.baseSubscription);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Consumer<Disposable> onSubscribe(final Observer<? super T> subscriber, final AtomicBoolean writeLocked) {
        return new Consumer<Disposable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Disposable subscription) {
                try {
                    ObservableRefCount.this.baseSubscription.add(subscription);
                    ObservableRefCount.this.doSubscribe(subscriber, ObservableRefCount.this.baseSubscription);
                }
                finally {
                    ObservableRefCount.this.lock.unlock();
                    writeLocked.set(false);
                }
            }
        };
    }

    void doSubscribe(Observer<? super T> subscriber, CompositeDisposable currentBase) {
        Disposable d = this.disconnect(currentBase);
        ConnectionSubscriber s = new ConnectionSubscriber(subscriber, currentBase, d);
        this.source.subscribe(s);
    }

    private Disposable disconnect(final CompositeDisposable current) {
        return Disposables.from(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObservableRefCount.this.lock.lock();
                try {
                    if (ObservableRefCount.this.baseSubscription == current && ObservableRefCount.this.subscriptionCount.decrementAndGet() == 0) {
                        ObservableRefCount.this.baseSubscription.dispose();
                        ObservableRefCount.this.baseSubscription = new CompositeDisposable();
                    }
                }
                finally {
                    ObservableRefCount.this.lock.unlock();
                }
            }
        });
    }

    final class ConnectionSubscriber
    implements Observer<T>,
    Disposable {
        final Observer<? super T> subscriber;
        final CompositeDisposable currentBase;
        final Disposable resource;
        Disposable s;

        ConnectionSubscriber(Observer<? super T> subscriber, CompositeDisposable currentBase, Disposable resource) {
            this.subscriber = subscriber;
            this.currentBase = currentBase;
            this.resource = resource;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.subscriber.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.cleanup();
            this.subscriber.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            this.cleanup();
            this.subscriber.onComplete();
        }

        @Override
        public void dispose() {
            this.s.dispose();
            this.resource.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            ObservableRefCount.this.lock.lock();
            try {
                if (ObservableRefCount.this.baseSubscription == this.currentBase) {
                    ObservableRefCount.this.baseSubscription.dispose();
                    ObservableRefCount.this.baseSubscription = new CompositeDisposable();
                    ObservableRefCount.this.subscriptionCount.set(0);
                }
            }
            finally {
                ObservableRefCount.this.lock.unlock();
            }
        }
    }
}

