/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.disposables.ObserverFullArbiter;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.subscribers.observable.FullArbiterObserver;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableTimeout<T, U, V>
extends AbstractObservableWithUpstream<T, T> {
    final Callable<? extends ObservableSource<U>> firstTimeoutSelector;
    final Function<? super T, ? extends ObservableSource<V>> timeoutSelector;
    final ObservableSource<? extends T> other;

    public ObservableTimeout(ObservableSource<T> source, Callable<? extends ObservableSource<U>> firstTimeoutSelector, Function<? super T, ? extends ObservableSource<V>> timeoutSelector, ObservableSource<? extends T> other) {
        super(source);
        this.firstTimeoutSelector = firstTimeoutSelector;
        this.timeoutSelector = timeoutSelector;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        if (this.other == null) {
            this.source.subscribe(new TimeoutSubscriber(new SerializedObserver<T>(t), this.firstTimeoutSelector, this.timeoutSelector));
        } else {
            this.source.subscribe(new TimeoutOtherSubscriber(t, this.firstTimeoutSelector, this.timeoutSelector, this.other));
        }
    }

    static final class TimeoutOtherSubscriber<T, U, V>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable,
    OnTimeout {
        private static final long serialVersionUID = -1957813281749686898L;
        final Observer<? super T> actual;
        final Callable<? extends ObservableSource<U>> firstTimeoutSelector;
        final Function<? super T, ? extends ObservableSource<V>> timeoutSelector;
        final ObservableSource<? extends T> other;
        final ObserverFullArbiter<T> arbiter;
        Disposable s;
        boolean done;
        volatile long index;

        public TimeoutOtherSubscriber(Observer<? super T> actual, Callable<? extends ObservableSource<U>> firstTimeoutSelector, Function<? super T, ? extends ObservableSource<V>> timeoutSelector, ObservableSource<? extends T> other) {
            this.actual = actual;
            this.firstTimeoutSelector = firstTimeoutSelector;
            this.timeoutSelector = timeoutSelector;
            this.other = other;
            this.arbiter = new ObserverFullArbiter<T>(actual, this, 8);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                if (!this.arbiter.setSubscription(s)) {
                    return;
                }
                Observer<T> a = this.actual;
                if (this.firstTimeoutSelector != null) {
                    ObservableSource<U> p;
                    try {
                        p = this.firstTimeoutSelector.call();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.dispose();
                        EmptyDisposable.error(ex, a);
                        return;
                    }
                    if (p == null) {
                        this.dispose();
                        EmptyDisposable.error((Throwable)new NullPointerException("The first timeout NbpObservable is null"), a);
                        return;
                    }
                    TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, 0L);
                    if (this.compareAndSet(null, tis)) {
                        a.onSubscribe(this.arbiter);
                        p.subscribe(tis);
                    }
                } else {
                    a.onSubscribe(this.arbiter);
                }
            }
        }

        @Override
        public void onNext(T t) {
            ObservableSource<V> p;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            if (!this.arbiter.onNext(t, this.s)) {
                return;
            }
            Disposable d = (Disposable)this.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = this.timeoutSelector.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            if (p == null) {
                this.actual.onError(new NullPointerException("The NbpObservable returned is null"));
                return;
            }
            TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, idx);
            if (this.compareAndSet(d, tis)) {
                p.subscribe(tis);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.arbiter.onError(t, this.s);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.arbiter.onComplete(this.s);
        }

        @Override
        public void dispose() {
            if (DisposableHelper.dispose(this)) {
                this.s.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void timeout(long idx) {
            if (idx == this.index) {
                this.dispose();
                this.other.subscribe(new FullArbiterObserver<T>(this.arbiter));
            }
        }
    }

    static final class TimeoutInnerSubscriber<T, U, V>
    extends DisposableObserver<Object> {
        final OnTimeout parent;
        final long index;
        boolean done;

        public TimeoutInnerSubscriber(OnTimeout parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onNext(Object t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.parent.timeout(this.index);
        }

        @Override
        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.timeout(this.index);
        }
    }

    static interface OnTimeout {
        public void timeout(long var1);

        public void onError(Throwable var1);
    }

    static final class TimeoutSubscriber<T, U, V>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable,
    OnTimeout {
        private static final long serialVersionUID = 2672739326310051084L;
        final Observer<? super T> actual;
        final Callable<? extends ObservableSource<U>> firstTimeoutSelector;
        final Function<? super T, ? extends ObservableSource<V>> timeoutSelector;
        Disposable s;
        volatile long index;

        public TimeoutSubscriber(Observer<? super T> actual, Callable<? extends ObservableSource<U>> firstTimeoutSelector, Function<? super T, ? extends ObservableSource<V>> timeoutSelector) {
            this.actual = actual;
            this.firstTimeoutSelector = firstTimeoutSelector;
            this.timeoutSelector = timeoutSelector;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                Observer<T> a = this.actual;
                if (this.firstTimeoutSelector != null) {
                    ObservableSource<U> p;
                    try {
                        p = this.firstTimeoutSelector.call();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.dispose();
                        EmptyDisposable.error(ex, a);
                        return;
                    }
                    if (p == null) {
                        this.dispose();
                        EmptyDisposable.error((Throwable)new NullPointerException("The first timeout NbpObservable is null"), a);
                        return;
                    }
                    TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, 0L);
                    if (this.compareAndSet(null, tis)) {
                        a.onSubscribe(this);
                        p.subscribe(tis);
                    }
                } else {
                    a.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            ObservableSource<V> p;
            long idx;
            this.index = idx = this.index + 1L;
            this.actual.onNext(t);
            Disposable d = (Disposable)this.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = this.timeoutSelector.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.actual.onError(e);
                return;
            }
            if (p == null) {
                this.dispose();
                this.actual.onError(new NullPointerException("The NbpObservable returned is null"));
                return;
            }
            TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, idx);
            if (this.compareAndSet(d, tis)) {
                p.subscribe(tis);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.dispose();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            if (DisposableHelper.dispose(this)) {
                this.s.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void timeout(long idx) {
            if (idx == this.index) {
                this.dispose();
                this.actual.onError(new TimeoutException());
            }
        }
    }
}

