/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public enum ObservableToFuture {


    public static <T> Future<T> toFuture(ObservableSource<? extends T> o) {
        final CountDownLatch cdl = new CountDownLatch(1);
        final AtomicReference value = new AtomicReference();
        final AtomicReference error = new AtomicReference();
        final SequentialDisposable sd = new SequentialDisposable();
        o.subscribe(new Observer<T>(){

            @Override
            public void onSubscribe(Disposable d) {
                sd.replace(d);
            }

            @Override
            public void onNext(T v) {
                if (value.get() != null) {
                    sd.dispose();
                    this.onError(new IndexOutOfBoundsException("More than one element received"));
                    return;
                }
                value.lazySet(v);
            }

            @Override
            public void onError(Throwable e) {
                error.lazySet(e);
                cdl.countDown();
            }

            @Override
            public void onComplete() {
                if (value.get() == null) {
                    this.onError(new NoSuchElementException("The source is empty"));
                    return;
                }
                cdl.countDown();
            }
        });
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (cdl.getCount() != 0L) {
                    sd.dispose();
                    error.set(new CancellationException());
                    cdl.countDown();
                    return true;
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return sd.isDisposed();
            }

            @Override
            public boolean isDone() {
                return cdl.getCount() == 0L && !sd.isDisposed();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                Throwable e;
                if (cdl.getCount() != 0L) {
                    cdl.await();
                }
                if ((e = (Throwable)error.get()) != null) {
                    if (e instanceof CancellationException) {
                        throw (CancellationException)e;
                    }
                    throw new ExecutionException(e);
                }
                return value.get();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (cdl.getCount() != 0L && !cdl.await(timeout, unit)) {
                    throw new TimeoutException();
                }
                Throwable e = (Throwable)error.get();
                if (e != null) {
                    if (e instanceof CancellationException) {
                        throw (CancellationException)e;
                    }
                    throw new ExecutionException(e);
                }
                return value.get();
            }
        };
    }
}

