/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.queue;

import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.LinkedQueueNode;
import java.util.concurrent.atomic.AtomicReference;

abstract class BaseLinkedQueue<E>
implements SimpleQueue<E> {
    private final AtomicReference<LinkedQueueNode<E>> producerNode = new AtomicReference();
    private final AtomicReference<LinkedQueueNode<E>> consumerNode = new AtomicReference();

    protected final LinkedQueueNode<E> lvProducerNode() {
        return this.producerNode.get();
    }

    protected final LinkedQueueNode<E> lpProducerNode() {
        return this.producerNode.get();
    }

    protected final void spProducerNode(LinkedQueueNode<E> node) {
        this.producerNode.lazySet(node);
    }

    protected final LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> node) {
        return this.producerNode.getAndSet(node);
    }

    protected final LinkedQueueNode<E> lvConsumerNode() {
        return this.consumerNode.get();
    }

    protected final LinkedQueueNode<E> lpConsumerNode() {
        return this.consumerNode.get();
    }

    protected final void spConsumerNode(LinkedQueueNode<E> node) {
        this.consumerNode.lazySet(node);
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }
}

