/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.flowable;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class LambdaSubscriber<T>
extends AtomicReference<Subscription>
implements Subscriber<T>,
Subscription,
Disposable {
    private static final long serialVersionUID = -7251123623727029452L;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Consumer<? super Subscription> onSubscribe;

    public LambdaSubscriber(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Subscription> onSubscribe) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onSubscribe = onSubscribe;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this, s)) {
            try {
                this.onSubscribe.accept(this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.onError(ex);
            }
        }
    }

    public void onNext(T t) {
        try {
            this.onNext.accept(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            this.onError(e);
        }
    }

    public void onError(Throwable t) {
        this.cancel();
        try {
            this.onError.accept(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            RxJavaPlugins.onError(t);
        }
    }

    public void onComplete() {
        this.cancel();
        try {
            this.onComplete.run();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    @Override
    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }

    public void request(long n) {
        ((Subscription)this.get()).request(n);
    }

    public void cancel() {
        SubscriptionHelper.cancel(this);
    }
}

