/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.flowable;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SubscriberResourceWrapper<T>
extends AtomicReference<Disposable>
implements Subscriber<T>,
Disposable,
Subscription {
    private static final long serialVersionUID = -8612022020200669122L;
    final Subscriber<? super T> actual;
    final AtomicReference<Subscription> subscription = new AtomicReference();
    static final Object TERMINATED = new Object();

    public SubscriberResourceWrapper(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    public void onSubscribe(Subscription s) {
        do {
            Subscription current;
            if ((current = this.subscription.get()) == SubscriptionHelper.CANCELLED) {
                s.cancel();
                return;
            }
            if (current == null) continue;
            s.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return;
        } while (!this.subscription.compareAndSet(null, s));
        this.actual.onSubscribe((Subscription)this);
    }

    public void onNext(T t) {
        this.actual.onNext(t);
    }

    public void onError(Throwable t) {
        this.dispose();
        this.actual.onError(t);
    }

    public void onComplete() {
        this.dispose();
        this.actual.onComplete();
    }

    public void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            this.subscription.get().request(n);
        }
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this.subscription);
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.subscription.get() == SubscriptionHelper.CANCELLED;
    }

    public void cancel() {
        this.dispose();
    }

    public void setResource(Disposable resource) {
        DisposableHelper.set(this, resource);
    }
}

