/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.LongConsumer;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SubscriptionLambdaSubscriber<T>
implements Subscriber<T>,
Subscription {
    final Subscriber<? super T> actual;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Action onCancel;
    Subscription s;

    public SubscriptionLambdaSubscriber(Subscriber<? super T> actual, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        this.actual = actual;
        this.onSubscribe = onSubscribe;
        this.onCancel = onCancel;
        this.onRequest = onRequest;
    }

    public void onSubscribe(Subscription s) {
        try {
            this.onSubscribe.accept((Subscription)s);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.cancel();
            RxJavaPlugins.onError(e);
            EmptySubscription.error(e, this.actual);
            return;
        }
        if (SubscriptionHelper.validate(this.s, s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(T t) {
        this.actual.onNext(t);
    }

    public void onError(Throwable t) {
        this.actual.onError(t);
    }

    public void onComplete() {
        this.actual.onComplete();
    }

    public void request(long n) {
        try {
            this.onRequest.accept(n);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
        this.s.request(n);
    }

    public void cancel() {
        try {
            this.onCancel.run();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
        this.s.cancel();
    }
}

