/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;

public class AppendOnlyLinkedArrayList<T> {
    final int capacity;
    final Object[] head;
    Object[] tail;
    int offset;

    public AppendOnlyLinkedArrayList(int capacity) {
        this.capacity = capacity;
        this.head = new Object[capacity + 1];
        this.tail = this.head;
    }

    public void add(T value) {
        int o = this.offset;
        int c = this.capacity;
        if (o == c) {
            Object[] next;
            this.tail[c] = next = new Object[c + 1];
            this.tail = next;
            o = 0;
        }
        this.tail[o] = value;
        this.offset = o + 1;
    }

    public void setFirst(T value) {
        this.head[0] = value;
    }

    public void forEach(Consumer<? super T> consumer) throws Exception {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            for (int i = 0; i < c; ++i) {
                Object o = a[i];
                if (o == null) {
                    return;
                }
                consumer.accept(o);
            }
            a = (Object[])a[c];
        }
    }

    public void forEachWhile(Predicate<? super T> consumer) throws Exception {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            for (int i = 0; i < c; ++i) {
                Object o = a[i];
                if (o == null) {
                    return;
                }
                if (!consumer.test(o)) continue;
                return;
            }
            a = (Object[])a[c];
        }
    }

    public <S> void forEachWhile(S state, BiPredicate<? super S, ? super T> consumer) throws Exception {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            for (int i = 0; i < c; ++i) {
                Object o = a[i];
                if (o == null) {
                    return;
                }
                if (!consumer.test(state, o)) continue;
                return;
            }
            a = (Object[])a[c];
        }
    }
}

