/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BehaviorSubject<T>
extends Subject<T> {
    final State<T> state;
    private static final Object[] EMPTY = new Object[0];

    public static <T> BehaviorSubject<T> create() {
        State state = new State();
        return new BehaviorSubject(state);
    }

    public static <T> BehaviorSubject<T> createDefault(T defaultValue) {
        ObjectHelper.requireNonNull(defaultValue, "defaultValue is null");
        State state = new State();
        state.lazySet(defaultValue);
        return new BehaviorSubject(state);
    }

    protected BehaviorSubject(State<T> state) {
        this.state = state;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.state.subscribe(observer);
    }

    @Override
    public void onSubscribe(Disposable s) {
        this.state.onSubscribe(s);
    }

    @Override
    public void onNext(T t) {
        if (t == null) {
            this.onError(new NullPointerException());
            return;
        }
        this.state.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        if (t == null) {
            t = new NullPointerException();
        }
        this.state.onError(t);
    }

    @Override
    public void onComplete() {
        this.state.onComplete();
    }

    @Override
    public boolean hasObservers() {
        return this.state.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.state.subscribers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.state.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public T getValue() {
        Object o = this.state.get();
        if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            return null;
        }
        return NotificationLite.getValue(o);
    }

    public Object[] getValues() {
        Object[] a = EMPTY;
        Object[] b = this.getValues(a);
        if (b == EMPTY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        Object o = this.state.get();
        if (o == null || NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        Object v = NotificationLite.getValue(o);
        if (array.length != 0) {
            array[0] = v;
            if (array.length != 1) {
                array[1] = null;
            }
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            array[0] = v;
        }
        return array;
    }

    @Override
    public boolean hasComplete() {
        Object o = this.state.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.state.get();
        return NotificationLite.isError(o);
    }

    public boolean hasValue() {
        Object o = this.state.get();
        return o != null && !NotificationLite.isComplete(o) && !NotificationLite.isError(o);
    }

    static final class BehaviorDisposable<T>
    implements Disposable,
    Predicate<Object> {
        final Observer<? super T> actual;
        final State<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        public BehaviorDisposable(Observer<? super T> actual, State<T> state) {
            this.actual = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o;
            if (this.cancelled) {
                return;
            }
            BehaviorDisposable behaviorDisposable = this;
            synchronized (behaviorDisposable) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                State<T> s = this.state;
                Lock lock = s.readLock;
                lock.lock();
                try {
                    this.index = s.index;
                    o = s.get();
                }
                finally {
                    lock.unlock();
                }
                this.emitting = o != null;
                this.next = true;
            }
            if (o != null) {
                if (this.test(o)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new AppendOnlyLinkedArrayList(4);
                        }
                        q.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o) {
            return this.cancelled || NotificationLite.accept(o, this.actual);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q;
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    q = this.queue;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                try {
                    q.forEachWhile(this);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.actual.onError(ex);
                    return;
                }
            }
            return;
        }
    }

    static final class State<T>
    extends AtomicReference<Object>
    implements ObservableSource<T>,
    Observer<T> {
        private static final long serialVersionUID = -4311717003288339429L;
        boolean done;
        final AtomicReference<BehaviorDisposable<T>[]> subscribers;
        static final BehaviorDisposable[] EMPTY = new BehaviorDisposable[0];
        static final BehaviorDisposable[] TERMINATED = new BehaviorDisposable[0];
        long index;
        final ReadWriteLock lock = new ReentrantReadWriteLock();
        final Lock readLock = this.lock.readLock();
        final Lock writeLock = this.lock.writeLock();

        public State() {
            this.subscribers = new AtomicReference<BehaviorDisposable[]>(EMPTY);
        }

        public boolean add(BehaviorDisposable<T> rs) {
            BehaviorDisposable[] b;
            BehaviorDisposable<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = a.length;
                b = new BehaviorDisposable[len + 1];
                System.arraycopy(a, 0, b, 0, len);
                b[len] = rs;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        public void remove(BehaviorDisposable<T> rs) {
            BehaviorDisposable[] b;
            BehaviorDisposable<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                    return;
                }
                int len = a.length;
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (a[i] != rs) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new BehaviorDisposable[len - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, len - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        public BehaviorDisposable<T>[] terminate(Object terminalValue) {
            BehaviorDisposable<T>[] a = this.subscribers.get();
            if (a != TERMINATED && (a = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
                this.setCurrent(terminalValue);
            }
            return a;
        }

        @Override
        public void subscribe(Observer<? super T> s) {
            BehaviorDisposable<T> bs = new BehaviorDisposable<T>(s, this);
            s.onSubscribe(bs);
            if (!bs.cancelled) {
                if (this.add(bs)) {
                    if (bs.cancelled) {
                        this.remove(bs);
                    } else {
                        bs.emitFirst();
                    }
                } else {
                    Object o = this.get();
                    if (NotificationLite.isComplete(o)) {
                        s.onComplete();
                    } else {
                        s.onError(NotificationLite.getError(o));
                    }
                }
            }
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (this.done) {
                s.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCurrent(Object o) {
            this.writeLock.lock();
            try {
                ++this.index;
                this.lazySet(o);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            Object o = NotificationLite.next(t);
            this.setCurrent(o);
            for (BehaviorDisposable<T> bs : this.subscribers.get()) {
                bs.emitNext(o, this.index);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            Object o = NotificationLite.error(t);
            for (BehaviorDisposable<T> bs : this.terminate(o)) {
                bs.emitNext(o, this.index);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Object o = NotificationLite.complete();
            for (BehaviorDisposable<T> bs : this.terminate(o)) {
                bs.emitNext(o, this.index);
            }
        }
    }
}

