/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishSubject<T>
extends Subject<T> {
    final State<T> state = new State();

    public static <T> PublishSubject<T> create() {
        return new PublishSubject<T>();
    }

    protected PublishSubject() {
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.state.subscribe(observer);
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (this.state.done) {
            d.dispose();
        }
    }

    @Override
    public void onNext(T value) {
        this.state.onNext(value);
    }

    @Override
    public void onError(Throwable e) {
        this.state.onError(e);
    }

    @Override
    public void onComplete() {
        this.state.onComplete();
    }

    @Override
    public boolean hasObservers() {
        return this.state.subscribers.get().length != 0;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.state.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    @Override
    public boolean hasComplete() {
        Object o = this.state.get();
        return o != null && !NotificationLite.isError(o);
    }

    @Override
    public boolean hasThrowable() {
        return NotificationLite.isError(this.state.get());
    }

    static final class State<T>
    extends AtomicReference<Object>
    implements ObservableSource<T>,
    Observer<T> {
        private static final long serialVersionUID = 4876574210612691772L;
        final AtomicReference<Observer<? super T>[]> subscribers = new AtomicReference();
        static final Observer[] EMPTY = new Observer[0];
        static final Observer[] TERMINATED = new Observer[0];
        volatile boolean done;

        public State() {
            this.subscribers.lazySet(EMPTY);
        }

        boolean add(Observer<? super T> s) {
            Observer[] b;
            Observer<? super T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new Observer[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = s;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        void remove(Observer<? super T> s) {
            Observer[] b;
            Observer<? super T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    Observer<T> e = a[i];
                    if (!e.equals(s)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new Observer[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        Observer<? super T>[] terminate(Object notification) {
            Observer<? super T>[] a;
            if (this.compareAndSet(null, notification) && (a = this.subscribers.get()) != TERMINATED) {
                return this.subscribers.getAndSet(TERMINATED);
            }
            return TERMINATED;
        }

        void emit(Observer<? super T> t, Object v) {
            if (NotificationLite.isComplete(v)) {
                t.onComplete();
            } else {
                t.onError(NotificationLite.getError(v));
            }
        }

        @Override
        public void subscribe(final Observer<? super T> t) {
            Object v = this.get();
            if (v != null) {
                t.onSubscribe(EmptyDisposable.INSTANCE);
                this.emit(t, v);
                return;
            }
            Disposable d = Disposables.from(new Runnable(){

                @Override
                public void run() {
                    State.this.remove(t);
                }
            });
            t.onSubscribe(d);
            if (this.add(t)) {
                if (d.isDisposed()) {
                    this.remove(t);
                }
                return;
            }
            v = this.get();
            this.emit(t, v);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (this.done) {
                d.dispose();
            }
        }

        @Override
        public void onNext(T value) {
            if (this.done) {
                return;
            }
            if (value == null) {
                this.onError(new NullPointerException("The value is null"));
                return;
            }
            for (Observer<T> observer : this.subscribers.get()) {
                observer.onNext(value);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.done = true;
            if (e == null) {
                e = new NullPointerException();
            }
            for (Observer<T> v : this.terminate(NotificationLite.error(e))) {
                v.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            for (Observer<T> v : this.terminate(NotificationLite.complete())) {
                v.onComplete();
            }
        }
    }
}

