/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplaySubject<T>
extends Subject<T> {
    final State<T> state;
    private static final Object[] EMPTY = new Object[0];

    public static <T> ReplaySubject<T> create() {
        return ReplaySubject.create(16);
    }

    public static <T> ReplaySubject<T> create(int capacityHint) {
        if (capacityHint <= 0) {
            throw new IllegalArgumentException("capacityHint > 0 required but it was " + capacityHint);
        }
        UnboundedReplayBuffer buffer = new UnboundedReplayBuffer(capacityHint);
        return ReplaySubject.createWithBuffer(buffer);
    }

    public static <T> ReplaySubject<T> createWithSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        SizeBoundReplayBuffer buffer = new SizeBoundReplayBuffer(size);
        return ReplaySubject.createWithBuffer(buffer);
    }

    static <T> ReplaySubject<T> createUnbounded() {
        SizeBoundReplayBuffer buffer = new SizeBoundReplayBuffer(Integer.MAX_VALUE);
        return ReplaySubject.createWithBuffer(buffer);
    }

    public static <T> ReplaySubject<T> createWithTime(long maxAge, TimeUnit unit, Scheduler scheduler) {
        return ReplaySubject.createWithTimeAndSize(maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ReplaySubject<T> createWithTimeAndSize(long maxAge, TimeUnit unit, Scheduler scheduler, int size) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        SizeAndTimeBoundReplayBuffer buffer = new SizeAndTimeBoundReplayBuffer(size, maxAge, unit, scheduler);
        return ReplaySubject.createWithBuffer(buffer);
    }

    static <T> ReplaySubject<T> createWithBuffer(ReplayBuffer<T> buffer) {
        State<T> state = new State<T>(buffer);
        return new ReplaySubject<T>(state);
    }

    protected ReplaySubject(State<T> state) {
        this.state = state;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.state.subscribe(observer);
    }

    @Override
    public void onSubscribe(Disposable s) {
        this.state.onSubscribe(s);
    }

    @Override
    public void onNext(T t) {
        if (t == null) {
            this.onError(new NullPointerException());
            return;
        }
        this.state.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        if (t == null) {
            t = new NullPointerException();
        }
        this.state.onError(t);
    }

    @Override
    public void onComplete() {
        this.state.onComplete();
    }

    @Override
    public boolean hasObservers() {
        return this.state.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.state.subscribers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.state.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public T getValue() {
        return this.state.buffer.getValue();
    }

    public Object[] getValues() {
        Object[] a = EMPTY;
        Object[] b = this.getValues(a);
        if (b == EMPTY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        return this.state.buffer.getValues(array);
    }

    @Override
    public boolean hasComplete() {
        Object o = this.state.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.state.get();
        return NotificationLite.isError(o);
    }

    public boolean hasValue() {
        return this.state.buffer.size() != 0;
    }

    int size() {
        return this.state.buffer.size();
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<Object> head;
        TimedNode<Object> tail;
        volatile boolean done;

        public SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.maxSize = maxSize;
            this.maxAge = maxAge;
            this.unit = unit;
            this.scheduler = scheduler;
            TimedNode<Object> h = new TimedNode<Object>(null, 0L);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<Object> h = this.head;
                this.head = (TimedNode)h.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h.get()) == null) {
                    this.head = h;
                    break;
                }
                if (next.time > limit) {
                    this.head = h;
                    break;
                }
                h = next;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h.get()).get() == null) {
                    this.head = h;
                    break;
                }
                if (next.time > limit) {
                    this.head = h;
                    break;
                }
                h = next;
            }
        }

        @Override
        public void add(T value) {
            TimedNode<T> n = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            TimedNode<Object> n = new TimedNode<Object>(notificationLite, Long.MAX_VALUE);
            TimedNode<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.lazySet(n);
            this.trimFinal();
            this.done = true;
        }

        @Override
        public T getValue() {
            TimedNode next;
            TimedNode prev = null;
            TimedNode h = this.head;
            while ((next = (TimedNode)h.get()) != null) {
                prev = h;
                h = next;
            }
            Object v = h.value;
            if (v == null) {
                return null;
            }
            if (NotificationLite.isComplete(v) || NotificationLite.isError(v)) {
                return prev.value;
            }
            return v;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h = this.head;
            int s = this.size();
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
                }
                for (int i = 0; i != s; ++i) {
                    TimedNode next = (TimedNode)h.get();
                    array[i] = next.value;
                    h = next;
                }
                if (array.length > s) {
                    array[s] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a = rs.actual;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.head;
                if (!this.done) {
                    long ts;
                    long limit = this.scheduler.now(this.unit) - this.maxAge;
                    TimedNode next = (TimedNode)index.get();
                    while (next != null && (ts = next.time) <= limit) {
                        index = next;
                        next = (TimedNode)index.get();
                    }
                }
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                while (true) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    TimedNode n = (TimedNode)index.get();
                    if (n == null) break;
                    Object o = n.value;
                    if (this.done && n.get() == null) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a.onNext(o);
                    index = n;
                }
                if (index.get() != null) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s;
            TimedNode h = this.head;
            for (s = 0; s != Integer.MAX_VALUE; ++s) {
                TimedNode next = (TimedNode)h.get();
                if (next == null) {
                    Object o = h.value;
                    if (!NotificationLite.isComplete(o) && !NotificationLite.isError(o)) break;
                    --s;
                    break;
                }
                h = next;
            }
            return s;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int maxSize;
        int size;
        volatile Node<Object> head;
        Node<Object> tail;
        volatile boolean done;

        public SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = maxSize;
            Node<Object> h = new Node<Object>(null);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<Object> h = this.head;
                this.head = (Node)h.get();
            }
        }

        @Override
        public void add(T value) {
            Node<T> n = new Node<T>(value);
            Node<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            Node<Object> n = new Node<Object>(notificationLite);
            Node<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.lazySet(n);
            this.done = true;
        }

        @Override
        public T getValue() {
            Node next;
            Node prev = null;
            Node h = this.head;
            while ((next = (Node)h.get()) != null) {
                prev = h;
                h = next;
            }
            Object v = h.value;
            if (v == null) {
                return null;
            }
            if (NotificationLite.isComplete(v) || NotificationLite.isError(v)) {
                return prev.value;
            }
            return v;
        }

        @Override
        public T[] getValues(T[] array) {
            Node h = this.head;
            int s = this.size();
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
                }
                for (int i = 0; i != s; ++i) {
                    Node next = (Node)h.get();
                    array[i] = next.value;
                    h = next;
                }
                if (array.length > s) {
                    array[s] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a = rs.actual;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.head;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                while (true) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    Node n = (Node)index.get();
                    if (n == null) break;
                    Object o = n.value;
                    if (this.done && n.get() == null) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a.onNext(o);
                    index = n;
                }
                if (index.get() != null) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s;
            Node h = this.head;
            for (s = 0; s != Integer.MAX_VALUE; ++s) {
                Node next = (Node)h.get();
                if (next == null) {
                    Object o = h.value;
                    if (!NotificationLite.isComplete(o) && !NotificationLite.isError(o)) break;
                    --s;
                    break;
                }
                h = next;
            }
            return s;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        public TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        public Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    implements ReplayBuffer<T> {
        final List<Object> buffer;
        volatile boolean done;
        volatile int size;

        public UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<Object>(capacityHint);
        }

        @Override
        public void add(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void addFinal(Object notificationLite) {
            this.buffer.add(notificationLite);
            ++this.size;
            this.done = true;
        }

        @Override
        public T getValue() {
            int s = this.size;
            if (s != 0) {
                List<Object> b = this.buffer;
                Object o = b.get(s - 1);
                if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                    if (s == 1) {
                        return null;
                    }
                    return (T)b.get(s - 2);
                }
                return (T)o;
            }
            return null;
        }

        @Override
        public T[] getValues(T[] array) {
            int s = this.size;
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<Object> b = this.buffer;
            Object o = b.get(s - 1);
            if ((NotificationLite.isComplete(o) || NotificationLite.isError(o)) && --s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            if (array.length < s) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
            }
            for (int i = 0; i < s; ++i) {
                array[i] = b.get(i);
            }
            if (array.length > s) {
                array[s] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<Object> b = this.buffer;
            Observer<Object> a = rs.actual;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                int s = this.size;
                while (s != index) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    Object o = b.get(index);
                    if (this.done && index + 1 == s && index + 1 == (s = this.size)) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a.onNext(o);
                    ++index;
                }
                if (index != this.size) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s = this.size;
            if (s != 0) {
                Object o = this.buffer.get(s - 1);
                if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                    return s - 1;
                }
                return s;
            }
            return 0;
        }
    }

    static final class ReplayDisposable<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 466549804534799122L;
        final Observer<? super T> actual;
        final State<T> state;
        Object index;
        volatile boolean cancelled;

        public ReplayDisposable(Observer<? super T> actual, State<T> state) {
            this.actual = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }
    }

    static interface ReplayBuffer<T> {
        public void add(T var1);

        public void addFinal(Object var1);

        public void replay(ReplayDisposable<T> var1);

        public int size();

        public T getValue();

        public T[] getValues(T[] var1);
    }

    static final class State<T>
    extends AtomicReference<Object>
    implements ObservableSource<T>,
    Observer<T> {
        private static final long serialVersionUID = -4673197222000219014L;
        final ReplayBuffer<T> buffer;
        boolean done;
        final AtomicReference<ReplayDisposable<T>[]> subscribers = new AtomicReference();
        static final ReplayDisposable[] EMPTY = new ReplayDisposable[0];
        static final ReplayDisposable[] TERMINATED = new ReplayDisposable[0];

        public State(ReplayBuffer<T> buffer) {
            this.buffer = buffer;
            this.subscribers.lazySet(EMPTY);
        }

        @Override
        public void subscribe(Observer<? super T> s) {
            ReplayDisposable<? super T> rs = new ReplayDisposable<T>(s, this);
            s.onSubscribe(rs);
            if (!rs.cancelled) {
                if (this.add(rs) && rs.cancelled) {
                    this.remove(rs);
                    return;
                }
                this.buffer.replay(rs);
            }
        }

        public boolean add(ReplayDisposable<T> rs) {
            ReplayDisposable[] b;
            ReplayDisposable<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = a.length;
                b = new ReplayDisposable[len + 1];
                System.arraycopy(a, 0, b, 0, len);
                b[len] = rs;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        public void remove(ReplayDisposable<T> rs) {
            ReplayDisposable[] b;
            ReplayDisposable<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                    return;
                }
                int len = a.length;
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (a[i] != rs) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new ReplayDisposable[len - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, len - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        public ReplayDisposable<T>[] terminate(Object terminalValue) {
            if (this.compareAndSet(null, terminalValue)) {
                return this.subscribers.getAndSet(TERMINATED);
            }
            return TERMINATED;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (this.done) {
                s.dispose();
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            ReplayBuffer<T> b = this.buffer;
            b.add(t);
            for (ReplayDisposable<T> rs : this.subscribers.get()) {
                b.replay(rs);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            Object o = NotificationLite.error(t);
            ReplayBuffer<T> b = this.buffer;
            b.addFinal(o);
            for (ReplayDisposable<T> rs : this.terminate(o)) {
                b.replay(rs);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Object o = NotificationLite.complete();
            ReplayBuffer<T> b = this.buffer;
            b.addFinal(o);
            for (ReplayDisposable<T> rs : this.terminate(o)) {
                b.replay(rs);
            }
        }
    }
}

