/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscribers.FullArbiterSubscriber;
import io.reactivex.internal.subscriptions.FullArbiter;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTimeoutTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Publisher<? extends T> other;
    static final Disposable NEW_TIMER = new Disposable(){

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return true;
        }
    };

    public FlowableTimeoutTimed(Publisher<T> source, long timeout, TimeUnit unit, Scheduler scheduler, Publisher<? extends T> other) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (this.other == null) {
            this.source.subscribe(new TimeoutTimedSubscriber<T>(new SerializedSubscriber<T>(s), this.timeout, this.unit, this.scheduler.createWorker()));
        } else {
            this.source.subscribe(new TimeoutTimedOtherSubscriber<T>(s, this.timeout, this.unit, this.scheduler.createWorker(), this.other));
        }
    }

    static final class TimeoutTimedSubscriber<T>
    implements Subscriber<T>,
    Disposable,
    Subscription {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Subscription s;
        final AtomicReference<Disposable> timer = new AtomicReference();
        volatile long index;
        volatile boolean done;

        TimeoutTimedSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                this.scheduleTimeout(0L);
            }
        }

        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            this.actual.onNext(t);
            this.scheduleTimeout(idx);
        }

        void scheduleTimeout(final long idx) {
            Disposable d = this.timer.get();
            if (d != null) {
                d.dispose();
            }
            if (this.timer.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (idx == TimeoutTimedSubscriber.this.index) {
                            TimeoutTimedSubscriber.this.done = true;
                            TimeoutTimedSubscriber.this.dispose();
                            TimeoutTimedSubscriber.this.actual.onError((Throwable)new TimeoutException());
                        }
                    }
                }, this.timeout, this.unit);
                DisposableHelper.replace(this.timer, d);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.worker.dispose();
            DisposableHelper.dispose(this.timer);
            this.s.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.dispose();
        }
    }

    static final class TimeoutTimedOtherSubscriber<T>
    implements Subscriber<T>,
    Disposable {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Publisher<? extends T> other;
        Subscription s;
        final FullArbiter<T> arbiter;
        final AtomicReference<Disposable> timer = new AtomicReference();
        volatile long index;
        volatile boolean done;

        TimeoutTimedOtherSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, Publisher<? extends T> other) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.other = other;
            this.arbiter = new FullArbiter<T>(actual, this, 8);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (this.arbiter.setSubscription(s)) {
                    this.actual.onSubscribe(this.arbiter);
                    this.scheduleTimeout(0L);
                }
            }
        }

        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            if (this.arbiter.onNext(t, this.s)) {
                this.scheduleTimeout(idx);
            }
        }

        void scheduleTimeout(final long idx) {
            Disposable d = this.timer.get();
            if (d != null) {
                d.dispose();
            }
            if (this.timer.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (idx == TimeoutTimedOtherSubscriber.this.index) {
                            TimeoutTimedOtherSubscriber.this.done = true;
                            TimeoutTimedOtherSubscriber.this.s.cancel();
                            DisposableHelper.dispose(TimeoutTimedOtherSubscriber.this.timer);
                            TimeoutTimedOtherSubscriber.this.subscribeNext();
                            TimeoutTimedOtherSubscriber.this.worker.dispose();
                        }
                    }
                }, this.timeout, this.unit);
                DisposableHelper.replace(this.timer, d);
            }
        }

        void subscribeNext() {
            this.other.subscribe(new FullArbiterSubscriber<T>(this.arbiter));
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.worker.dispose();
            DisposableHelper.dispose(this.timer);
            this.arbiter.onError(t, this.s);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.worker.dispose();
            DisposableHelper.dispose(this.timer);
            this.arbiter.onComplete(this.s);
        }

        @Override
        public void dispose() {
            this.worker.dispose();
            DisposableHelper.dispose(this.timer);
            this.s.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }
    }
}

