/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowables;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.Experimental;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableAutoConnect;
import io.reactivex.internal.operators.flowable.FlowableRefCount;
import io.reactivex.internal.util.ConnectConsumer;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public abstract class ConnectableFlowable<T>
extends Flowable<T> {
    public abstract void connect(@NonNull Consumer<? super Disposable> var1);

    public final Disposable connect() {
        ConnectConsumer cc = new ConnectConsumer();
        this.connect(cc);
        return cc.disposable;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public Flowable<T> refCount() {
        return RxJavaPlugins.onAssembly(new FlowableRefCount(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @Experimental
    public final Flowable<T> refCount(int subscriberCount) {
        return this.refCount(subscriberCount, 0L, TimeUnit.NANOSECONDS, Schedulers.trampoline());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @Experimental
    public final Flowable<T> refCount(long timeout, TimeUnit unit) {
        return this.refCount(1, timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @Experimental
    public final Flowable<T> refCount(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.refCount(1, timeout, unit, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @Experimental
    public final Flowable<T> refCount(int subscriberCount, long timeout, TimeUnit unit) {
        return this.refCount(subscriberCount, timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @Experimental
    public final Flowable<T> refCount(int subscriberCount, long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.verifyPositive(subscriberCount, "subscriberCount");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableRefCount(this, subscriberCount, timeout, unit, scheduler));
    }

    @NonNull
    public Flowable<T> autoConnect() {
        return this.autoConnect(1);
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers) {
        return this.autoConnect(numberOfSubscribers, Functions.emptyConsumer());
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers, @NonNull Consumer<? super Disposable> connection) {
        if (numberOfSubscribers <= 0) {
            this.connect(connection);
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new FlowableAutoConnect(this, numberOfSubscribers, connection));
    }
}

