/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpRequestHeaders {
    private final HttpRequest nettyRequest;
    private final HttpHeaders nettyHeaders;

    public HttpRequestHeaders(HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
        this.nettyHeaders = this.nettyRequest.headers();
    }

    public HttpHeaders add(HttpHeaders headers) {
        return this.nettyHeaders.add(headers);
    }

    public HttpHeaders add(CharSequence name, Object value) {
        return this.nettyHeaders.add(name, value);
    }

    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        return this.nettyHeaders.add(name, values);
    }

    public HttpHeaders add(String name, Object value) {
        return this.nettyHeaders.add(name, value);
    }

    public HttpHeaders add(String name, Iterable<?> values) {
        return this.nettyHeaders.add(name, values);
    }

    public void addDateHeader(CharSequence name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (Date)value);
    }

    public void addDateHeader(String name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyRequest, (String)name, (Date)value);
    }

    public void addHeader(CharSequence name, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (Object)value);
    }

    public void addHeader(String name, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyRequest, (String)name, (Object)value);
    }

    public void addIntHeader(CharSequence name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (int)value);
    }

    public void addIntHeader(String name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyRequest, (String)name, (int)value);
    }

    public HttpHeaders clear() {
        return this.nettyHeaders.clear();
    }

    public void clearHeaders() {
        HttpHeaders.clearHeaders((HttpMessage)this.nettyRequest);
    }

    public boolean contains(CharSequence name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(String name, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public void encodeAscii(CharSequence seq, ByteBuf buf) {
        HttpHeaders.encodeAscii((CharSequence)seq, (ByteBuf)buf);
    }

    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    public boolean equalsIgnoreCase(CharSequence name1, CharSequence name2) {
        return HttpHeaders.equalsIgnoreCase((CharSequence)name1, (CharSequence)name2);
    }

    public String get(CharSequence name) {
        return this.nettyHeaders.get(name);
    }

    public String get(String name) {
        return this.nettyHeaders.get(name);
    }

    public List<String> getAll(CharSequence name) {
        return this.nettyHeaders.getAll(name);
    }

    public List<String> getAll(String name) {
        return this.nettyHeaders.getAll(name);
    }

    public long getContentLength() {
        return HttpHeaders.getContentLength((HttpMessage)this.nettyRequest);
    }

    public long getContentLength(long defaultValue) {
        return HttpHeaders.getContentLength((HttpMessage)this.nettyRequest, (long)defaultValue);
    }

    public Date getDate() throws ParseException {
        return HttpHeaders.getDate((HttpMessage)this.nettyRequest);
    }

    public Date getDate(Date defaultValue) {
        return HttpHeaders.getDate((HttpMessage)this.nettyRequest, (Date)defaultValue);
    }

    public Date getDateHeader(CharSequence name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (CharSequence)name);
    }

    public Date getDateHeader(CharSequence name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (Date)defaultValue);
    }

    public Date getDateHeader(String name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    public Date getDateHeader(String name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (String)name, (Date)defaultValue);
    }

    public String getHeader(CharSequence name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (CharSequence)name);
    }

    public String getHeader(CharSequence name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (String)defaultValue);
    }

    public String getHeader(String name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    public String getHeader(String name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, (String)name, (String)defaultValue);
    }

    public String getHost() {
        return HttpHeaders.getHost((HttpMessage)this.nettyRequest);
    }

    public String getHost(String defaultValue) {
        return HttpHeaders.getHost((HttpMessage)this.nettyRequest, (String)defaultValue);
    }

    public int getIntHeader(CharSequence name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (CharSequence)name);
    }

    public int getIntHeader(CharSequence name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (int)defaultValue);
    }

    public int getIntHeader(String name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    public int getIntHeader(String name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, (String)name, (int)defaultValue);
    }

    public boolean is100ContinueExpected() {
        return HttpHeaders.is100ContinueExpected((HttpMessage)this.nettyRequest);
    }

    public boolean isContentLengthSet() {
        return HttpHeaders.isContentLengthSet((HttpMessage)this.nettyRequest);
    }

    public boolean hasContent() {
        if (this.isContentLengthSet()) {
            return this.getContentLength() > 0L;
        }
        return this.isTransferEncodingChunked();
    }

    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    public boolean isTransferEncodingChunked() {
        return HttpHeaders.isTransferEncodingChunked((HttpMessage)this.nettyRequest);
    }

    public Set<String> names() {
        return this.nettyHeaders.names();
    }

    public CharSequence newEntity(String name) {
        return HttpHeaders.newEntity((String)name);
    }

    public HttpHeaders remove(CharSequence name) {
        return this.nettyHeaders.remove(name);
    }

    public HttpHeaders remove(String name) {
        return this.nettyHeaders.remove(name);
    }

    public void removeHeader(CharSequence name) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyRequest, (CharSequence)name);
    }

    public void removeHeader(String name) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    public void removeTransferEncodingChunked() {
        HttpHeaders.removeTransferEncodingChunked((HttpMessage)this.nettyRequest);
    }

    public HttpHeaders set(HttpHeaders headers) {
        return this.nettyHeaders.set(headers);
    }

    public HttpHeaders set(CharSequence name, Object value) {
        return this.nettyHeaders.set(name, value);
    }

    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        return this.nettyHeaders.set(name, values);
    }

    public HttpHeaders set(String name, Object value) {
        return this.nettyHeaders.set(name, value);
    }

    public HttpHeaders set(String name, Iterable<?> values) {
        return this.nettyHeaders.set(name, values);
    }

    public void set100ContinueExpected() {
        HttpHeaders.set100ContinueExpected((HttpMessage)this.nettyRequest);
    }

    public void set100ContinueExpected(boolean set) {
        HttpHeaders.set100ContinueExpected((HttpMessage)this.nettyRequest, (boolean)set);
    }

    public void setContentLength(long length) {
        HttpHeaders.setContentLength((HttpMessage)this.nettyRequest, (long)length);
    }

    public void setDate(Date value) {
        HttpHeaders.setDate((HttpMessage)this.nettyRequest, (Date)value);
    }

    public void setDateHeader(CharSequence name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (Date)value);
    }

    public void setDateHeader(CharSequence name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, (CharSequence)name, values);
    }

    public void setDateHeader(String name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, (String)name, (Date)value);
    }

    public void setDateHeader(String name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, (String)name, values);
    }

    public void setHeader(CharSequence name, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (Object)value);
    }

    public void setHeader(CharSequence name, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, (CharSequence)name, values);
    }

    public void setHeader(String name, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, (String)name, (Object)value);
    }

    public void setHeader(String name, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, (String)name, values);
    }

    public void setHost(CharSequence value) {
        HttpHeaders.setHost((HttpMessage)this.nettyRequest, (CharSequence)value);
    }

    public void setHost(String value) {
        HttpHeaders.setHost((HttpMessage)this.nettyRequest, (String)value);
    }

    public void setIntHeader(CharSequence name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, (CharSequence)name, (int)value);
    }

    public void setIntHeader(CharSequence name, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, (CharSequence)name, values);
    }

    public void setIntHeader(String name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, (String)name, (int)value);
    }

    public void setIntHeader(String name, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, (String)name, values);
    }

    public void setKeepAlive(boolean keepAlive) {
        HttpHeaders.setKeepAlive((HttpMessage)this.nettyRequest, (boolean)keepAlive);
    }

    public void setTransferEncodingChunked() {
        HttpHeaders.setTransferEncodingChunked((HttpMessage)this.nettyRequest);
    }
}

