/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.internal.path.json;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import io.restassured.internal.common.assertion.Assertion;
import io.restassured.internal.common.assertion.AssertionSupport;
import io.restassured.internal.common.assertion.PathFragmentEscaper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.InvokerHelper;

public class JSONAssertion
implements Assertion {
    private static final String ROOT = "restAssuredJsonRootObject";
    private static final String SCRIPT_NAME = "Script1";
    private static final Pattern KEY_PATTERN = Pattern.compile("^\\[-?\\d+].*");
    String key;
    Map<String, Object> params;

    @Override
    public Object getResult(Object object, Object config) {
        return this.getAsJsonObject(object);
    }

    @Override
    public String description() {
        return "JSON path";
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Object getAsJsonObject(Object object) {
        Object result;
        this.key = (String)AssertionSupport.escapePath(this.key, (PathFragmentEscaper)AssertionSupport.hyphen(), (PathFragmentEscaper)AssertionSupport.attributeGetter(), (PathFragmentEscaper)AssertionSupport.integer(), (PathFragmentEscaper)AssertionSupport.classKeyword());
        if ("$".equals(this.key) || this.key.isEmpty()) {
            result = object;
        } else {
            try {
                String expr = KEY_PATTERN.matcher(this.key).matches() ? ROOT + this.key : "restAssuredJsonRootObject." + this.key;
                result = this.eval(ROOT, object, expr);
            }
            catch (MissingPropertyException e) {
                String message = e.getMessage();
                if (message != null && message.startsWith("No such property:") && message.endsWith("for class: Script1")) {
                    String error = String.format("The parameter \"%s\" was used but not defined. Define parameters using the JsonPath.param(...) function", e.getProperty());
                    throw new IllegalArgumentException(error, e);
                }
                return null;
            }
            catch (Exception e) {
                String message;
                if (e instanceof NullPointerException && ((message = e.getMessage()).equals("Cannot invoke method getAt() on null object") || message.startsWith("Cannot get property") && message.endsWith("on null object"))) {
                    return null;
                }
                String error = e.getMessage().replace("startup failed:", "Invalid JSON expression:").replace("$root.", AssertionSupport.generateWhitespace(ROOT.length()));
                throw new IllegalArgumentException(error, e);
            }
        }
        return result;
    }

    private Object eval(String root, Object object, String expr) {
        Object object2;
        HashMap<String, Object> newParams = this.params != null ? new HashMap<String, Object>(this.params) : new HashMap(1);
        newParams.put(root, object);
        GroovyClassLoader loader = new GroovyClassLoader();
        try {
            Class scriptClass = loader.parseClass(expr, "Script1.groovy");
            Script script = InvokerHelper.createScript((Class)scriptClass, (Binding)new Binding(newParams));
            object2 = script.run();
        }
        catch (Throwable throwable) {
            try {
                try {
                    loader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        loader.close();
        return object2;
    }
}

