/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.config.LogConfig;
import io.restassured.internal.RestAssuredResponseOptionsImpl;
import io.restassured.internal.assertion.AssertParameter;
import io.restassured.internal.log.LogRepository;
import io.restassured.module.mockmvc.internal.ValidatableMockMvcResponseImpl;
import io.restassured.module.mockmvc.response.MockMvcResponse;
import io.restassured.module.mockmvc.response.ValidatableMockMvcResponse;
import io.restassured.response.ExtractableResponse;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultActions;

public class MockMvcRestAssuredResponseImpl
extends RestAssuredResponseOptionsImpl<MockMvcResponse>
implements MockMvcResponse {
    private final ResultActions resultActions;
    private final LogRepository logRepository;

    public MockMvcRestAssuredResponseImpl(ResultActions resultActions, LogRepository logRepository) {
        AssertParameter.notNull((Object)resultActions, ResultActions.class);
        AssertParameter.notNull((Object)logRepository, LogRepository.class);
        this.resultActions = resultActions;
        this.logRepository = logRepository;
    }

    public ValidatableMockMvcResponse then() {
        ValidatableMockMvcResponseImpl response = new ValidatableMockMvcResponseImpl(this.resultActions, this.getContentType(), this.getRpr(), this.getConfig(), this, (ExtractableResponse<MockMvcResponse>)this, this.logRepository);
        LogConfig logConfig = this.getConfig().getLogConfig();
        if (logConfig.isLoggingOfRequestAndResponseIfValidationFailsEnabled()) {
            response.log().ifValidationFails(logConfig.logDetailOfRequestAndResponseIfValidationFails(), logConfig.isPrettyPrintingEnabled());
        }
        return response;
    }

    @Override
    public MvcResult mvcResult() {
        return this.resultActions.andReturn();
    }

    @Override
    public MvcResult getMvcResult() {
        return this.mvcResult();
    }

    @Override
    public MockHttpServletResponse mockHttpServletResponse() {
        return this.mvcResult().getResponse();
    }

    @Override
    public MockHttpServletResponse getMockHttpServletResponse() {
        return this.mockHttpServletResponse();
    }
}

