/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.config.EncoderConfig;
import io.restassured.config.HeaderConfig;
import io.restassured.config.LogConfig;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.http.Method;
import io.restassured.internal.MapCreator;
import io.restassured.internal.common.assertion.AssertParameter;
import io.restassured.internal.log.LogRepository;
import io.restassured.internal.mapping.ObjectMapping;
import io.restassured.internal.serialization.SerializationSupport;
import io.restassured.internal.support.ParameterUpdater;
import io.restassured.mapper.ObjectMapper;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import io.restassured.module.mockmvc.intercept.MockHttpServletRequestBuilderInterceptor;
import io.restassured.module.mockmvc.internal.MockMvcFactory;
import io.restassured.module.mockmvc.internal.MockMvcMultiPart;
import io.restassured.module.mockmvc.internal.MockMvcRequestLogSpecificationImpl;
import io.restassured.module.mockmvc.internal.MockMvcRequestSenderImpl;
import io.restassured.module.mockmvc.internal.SpringSecurityClassPathChecker;
import io.restassured.module.mockmvc.internal.StandaloneMockMvcFactory;
import io.restassured.module.mockmvc.internal.UpdateStrategyConverter;
import io.restassured.module.mockmvc.response.MockMvcResponse;
import io.restassured.module.mockmvc.specification.MockMvcAuthenticationScheme;
import io.restassured.module.mockmvc.specification.MockMvcAuthenticationSpecification;
import io.restassured.module.mockmvc.specification.MockMvcRequestAsyncSender;
import io.restassured.module.mockmvc.specification.MockMvcRequestLogSpecification;
import io.restassured.module.mockmvc.specification.MockMvcRequestSpecification;
import io.restassured.module.spring.commons.BodyHelper;
import io.restassured.module.spring.commons.CookieHelper;
import io.restassured.module.spring.commons.HeaderHelper;
import io.restassured.module.spring.commons.Serializer;
import io.restassured.module.spring.commons.config.AsyncConfig;
import io.restassured.module.spring.commons.config.ConfigConverter;
import io.restassured.module.spring.commons.config.ConfigMergeUtils;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public class MockMvcRequestSpecificationImpl
implements MockMvcRequestSpecification,
MockMvcAuthenticationSpecification {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT = "Accept";
    private LogRepository logRepository;
    private MockMvcFactory mockMvcFactory;
    private String basePath;
    private final ResponseSpecification responseSpecification;
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();
    private final Map<String, Object> queryParams = new LinkedHashMap<String, Object>();
    private final Map<String, Object> formParams = new LinkedHashMap<String, Object>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private Object requestBody = null;
    private RestAssuredMockMvcConfig cfg;
    private Headers requestHeaders = new Headers(new Header[0]);
    private Cookies cookies = new Cookies(new Cookie[0]);
    private List<MockMvcMultiPart> multiParts = new ArrayList<MockMvcMultiPart>();
    private RequestLoggingFilter requestLoggingFilter;
    private final ParameterUpdater parameterUpdater = new ParameterUpdater(new ParameterUpdater.Serializer(){

        public String serializeIfNeeded(Object value) {
            return MockMvcRequestSpecificationImpl.this.serializeIfNeeded(value);
        }
    });
    private final List<ResultHandler> resultHandlers = new ArrayList<ResultHandler>();
    private final List<RequestPostProcessor> requestPostProcessors = new ArrayList<RequestPostProcessor>();
    private MockHttpServletRequestBuilderInterceptor interceptor;
    private Object authentication;
    private AsyncConfig asyncConfig;
    private final Map<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();

    public MockMvcRequestSpecificationImpl(MockMvcFactory mockMvcFactory, RestAssuredMockMvcConfig config, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, String basePath, MockMvcRequestSpecification requestSpecification, ResponseSpecification responseSpecification, MockMvcAuthenticationScheme authentication) {
        this.logRepository = new LogRepository();
        this.mockMvcFactory = mockMvcFactory == null ? new MockMvcFactory() : mockMvcFactory;
        this.basePath = basePath;
        this.responseSpecification = responseSpecification;
        this.assignConfig(config);
        if (resultHandlers != null) {
            this.resultHandlers.addAll(resultHandlers);
        }
        if (requestPostProcessors != null) {
            this.requestPostProcessors.addAll(requestPostProcessors);
        }
        if (requestSpecification != null) {
            this.spec(requestSpecification);
        }
        if (authentication != null) {
            authentication.authenticate(this);
        }
    }

    @Override
    public MockMvcRequestSpecification mockMvc(MockMvc mockMvc) {
        AssertParameter.notNull((Object)mockMvc, MockMvc.class);
        return this.changeMockMvcFactoryTo(new MockMvcFactory(mockMvc));
    }

    @Override
    public MockMvcRequestSpecification standaloneSetup(Object ... controllerOrMockMvcConfigurer) {
        MockMvcFactory mockMvcFactory = StandaloneMockMvcFactory.of(controllerOrMockMvcConfigurer);
        return this.changeMockMvcFactoryTo(mockMvcFactory);
    }

    @Override
    public MockMvcRequestSpecification standaloneSetup(MockMvcBuilder builder) {
        AssertParameter.notNull((Object)builder, MockMvcBuilder.class);
        return this.changeMockMvcFactoryTo(new MockMvcFactory(builder));
    }

    @Override
    public MockMvcRequestSpecification webAppContextSetup(WebApplicationContext context, MockMvcConfigurer ... mockMvcConfigurers) {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup((WebApplicationContext)context);
        if (mockMvcConfigurers != null && mockMvcConfigurers.length > 0) {
            for (MockMvcConfigurer mockMvcConfigurer : mockMvcConfigurers) {
                builder.apply(mockMvcConfigurer);
            }
        }
        return this.changeMockMvcFactoryTo(new MockMvcFactory((MockMvcBuilder)builder));
    }

    @Override
    public MockMvcRequestSpecification interceptor(MockHttpServletRequestBuilderInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    @Override
    public MockMvcRequestSpecification and() {
        return this;
    }

    @Override
    public MockMvcRequestSpecification postProcessors(RequestPostProcessor postProcessor, RequestPostProcessor ... additionalPostProcessors) {
        AssertParameter.notNull((Object)postProcessor, RequestPostProcessor.class);
        this.requestPostProcessors.add(postProcessor);
        if (additionalPostProcessors != null && additionalPostProcessors.length >= 1) {
            Collections.addAll(this.requestPostProcessors, additionalPostProcessors);
        }
        return this;
    }

    @Override
    public MockMvcAuthenticationSpecification auth() {
        return this;
    }

    @Override
    public MockMvcRequestSpecification contentType(ContentType contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(CONTENT_TYPE, contentType.toString(), new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification contentType(MediaType mediaType) {
        AssertParameter.notNull((Object)mediaType, (String)"mediaType");
        return this.header(CONTENT_TYPE, mediaType.toString(), new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification contentType(String contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(CONTENT_TYPE, contentType, new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification accept(ContentType contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(ACCEPT, contentType.getAcceptHeader(), new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification accept(MediaType ... mediaTypes) {
        AssertParameter.notNull((Object)mediaTypes, (String)"mediaTypes");
        return this.header(ACCEPT, MediaType.toString(Arrays.asList(mediaTypes)), new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification accept(String mediaTypes) {
        AssertParameter.notNull((Object)mediaTypes, (String)"mediaTypes");
        return this.header(ACCEPT, mediaTypes, new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification headers(String firstHeaderName, Object firstHeaderValue, Object ... headerNameValuePairs) {
        return this.headers(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.MERGE, (String)firstHeaderName, (Object)firstHeaderValue, (Object[])headerNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification headers(Map<String, ?> headers) {
        AssertParameter.notNull(headers, (String)"headers");
        this.requestHeaders = HeaderHelper.headers((Headers)this.requestHeaders, headers, (SpecificationConfig)this.cfg);
        return this;
    }

    @Override
    public MockMvcRequestSpecification headers(Headers headers) {
        AssertParameter.notNull((Object)headers, (String)"Headers");
        this.requestHeaders = HeaderHelper.headers((Headers)this.requestHeaders, (Headers)headers, (HeaderConfig)this.cfg.getHeaderConfig());
        return this;
    }

    @Override
    public MockMvcRequestSpecification header(String headerName, Object headerValue, Object ... additionalHeaderValues) {
        AssertParameter.notNull((Object)headerName, (String)"Header name");
        AssertParameter.notNull((Object)headerValue, (String)"Header value");
        return this.headers(HeaderHelper.headers((Headers)this.requestHeaders, (String)headerName, (Object)headerValue, (SpecificationConfig)this.cfg, (Object[])additionalHeaderValues));
    }

    @Override
    public MockMvcRequestSpecification header(Header header) {
        AssertParameter.notNull((Object)header, (String)"Header");
        return this.headers(new Headers(Collections.singletonList(header)));
    }

    @Override
    public MockMvcRequestLogSpecification log() {
        return new MockMvcRequestLogSpecificationImpl(this);
    }

    @Override
    public MockMvcRequestSpecification params(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.params(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification params(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().requestParamsUpdateStrategy()), parametersMap, this.params);
        return this;
    }

    @Override
    public MockMvcRequestSpecification param(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().requestParamsUpdateStrategy()), this.params, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification param(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(UpdateStrategyConverter.convert(this.cfg.getParamConfig().requestParamsUpdateStrategy()), this.params, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification queryParams(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.queryParams(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification queryParams(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().queryParamsUpdateStrategy()), parametersMap, this.queryParams);
        return this;
    }

    @Override
    public MockMvcRequestSpecification queryParam(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().queryParamsUpdateStrategy()), this.queryParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification queryParam(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(UpdateStrategyConverter.convert(this.cfg.getParamConfig().queryParamsUpdateStrategy()), this.queryParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification formParams(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.formParams(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification formParams(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().formParamsUpdateStrategy()), parametersMap, this.formParams);
        return this;
    }

    @Override
    public MockMvcRequestSpecification formParam(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().formParamsUpdateStrategy()), this.formParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification formParam(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(UpdateStrategyConverter.convert(this.cfg.getParamConfig().formParamsUpdateStrategy()), this.formParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification attribute(String attributeName, Object attributeValue) {
        AssertParameter.notNull((Object)attributeName, (String)"attributeName");
        AssertParameter.notNull((Object)attributeValue, (String)"attributeValue");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getMockMvcParamConfig().attributeUpdateStrategy()), this.attributes, attributeName, new Object[]{attributeValue});
        return this;
    }

    @Override
    public MockMvcRequestSpecification attributes(Map<String, ?> attributesMap) {
        AssertParameter.notNull(attributesMap, (String)"attributesMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getMockMvcParamConfig().attributeUpdateStrategy()), attributesMap, this.attributes);
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(String body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(byte[] body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(File body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(Object object) {
        AssertParameter.notNull((Object)object, (String)"object");
        if (!SerializationSupport.isSerializableCandidate((Object)object)) {
            return this.body(object.toString());
        }
        String requestContentType = this.getRequestContentType();
        this.requestBody = ObjectMapping.serialize((Object)object, (String)requestContentType, (String)Serializer.findEncoderCharsetOrReturnDefault((String)requestContentType, (SpecificationConfig)this.cfg), null, (ObjectMapperConfig)this.cfg.getObjectMapperConfig(), (EncoderConfig)this.cfg.getEncoderConfig());
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(Object object, ObjectMapper mapper) {
        AssertParameter.notNull((Object)object, (String)"object");
        AssertParameter.notNull((Object)mapper, (String)"Object mapper");
        this.requestBody = BodyHelper.toSerializedBody((Object)object, (ObjectMapper)mapper, (SpecificationConfig)this.cfg, (Headers)this.requestHeaders);
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(Object object, ObjectMapperType mapperType) {
        AssertParameter.notNull((Object)object, (String)"object");
        AssertParameter.notNull((Object)mapperType, (String)"Object mapper type");
        String requestContentType = this.getRequestContentType();
        this.requestBody = ObjectMapping.serialize((Object)object, (String)requestContentType, (String)Serializer.findEncoderCharsetOrReturnDefault((String)requestContentType, (SpecificationConfig)this.cfg), (ObjectMapperType)mapperType, (ObjectMapperConfig)this.cfg.getObjectMapperConfig(), (EncoderConfig)this.cfg.getEncoderConfig());
        return this;
    }

    @Override
    public MockMvcRequestSpecification cookies(String firstCookieName, Object firstCookieValue, Object ... cookieNameValuePairs) {
        return this.cookies(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstCookieName, (Object)firstCookieValue, (Object[])cookieNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification cookies(Map<String, ?> cookies) {
        AssertParameter.notNull(cookies, (String)"cookies");
        this.cookies = CookieHelper.cookies((Cookies)this.cookies, cookies, (Headers)this.requestHeaders, (SpecificationConfig)this.cfg);
        return this;
    }

    @Override
    public MockMvcRequestSpecification cookies(Cookies cookies) {
        AssertParameter.notNull((Object)cookies, (String)"Cookies");
        this.cookies = CookieHelper.cookies((Cookies)this.cookies, (Cookies)cookies);
        return this;
    }

    @Override
    public MockMvcRequestSpecification cookie(String cookieName, Object cookieValue, Object ... additionalValues) {
        AssertParameter.notNull((Object)cookieName, (String)"Cookie name");
        AssertParameter.notNull((Object)cookieValue, (String)"Cookie value");
        return this.cookies(CookieHelper.cookie((String)cookieName, (Object)cookieValue, (Headers)this.requestHeaders, (SpecificationConfig)this.cfg, (Object[])additionalValues));
    }

    @Override
    public MockMvcRequestSpecification cookie(Cookie cookie) {
        AssertParameter.notNull((Object)cookie, (String)"Cookie");
        return this.cookies(new Cookies(Collections.singletonList(cookie)));
    }

    @Override
    public MockMvcRequestSpecification multiPart(File file) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), file));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, File file) {
        this.multiParts.add(new MockMvcMultiPart(controlName, file));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, File file, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, file, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, Object object) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, this.serializeIfNeeded(object)));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, Object object, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, Serializer.serializeIfNeeded((Object)object, (String)mimeType, (SpecificationConfig)this.cfg), mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String filename, Object object, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, filename, (Object)Serializer.serializeIfNeeded((Object)object, (String)mimeType, (SpecificationConfig)this.cfg), mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, byte[] bytes) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, bytes));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, byte[] bytes, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, bytes, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, InputStream stream) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, stream));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, InputStream stream, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, stream, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String contentBody) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, contentBody));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String contentBody, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, contentBody, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification config(RestAssuredMockMvcConfig config) {
        this.assignConfig(config);
        return this;
    }

    @Override
    public MockMvcRequestSpecification spec(MockMvcRequestSpecification requestSpecificationToMerge) {
        AsyncConfig otherAsyncConfig;
        Object otherAuth;
        MockMvcFactory otherMockMvcFactory;
        AssertParameter.notNull((Object)requestSpecificationToMerge, MockMvcRequestSpecification.class);
        if (!(requestSpecificationToMerge instanceof MockMvcRequestSpecificationImpl)) {
            throw new IllegalArgumentException("requestSpecificationToMerge must be an instance of " + MockMvcRequestSpecificationImpl.class.getName());
        }
        MockMvcRequestSpecificationImpl that = (MockMvcRequestSpecificationImpl)requestSpecificationToMerge;
        Object otherRequestBody = that.getRequestBody();
        if (otherRequestBody != null) {
            this.requestBody = otherRequestBody;
        }
        if (StringUtils.isNotEmpty((CharSequence)that.getBasePath())) {
            this.basePath = that.getBasePath();
        }
        if ((otherMockMvcFactory = that.getMockMvcFactory()) != null && otherMockMvcFactory.isAssigned()) {
            this.changeMockMvcFactoryTo(otherMockMvcFactory);
        }
        this.cookies(that.getCookies());
        this.headers(that.getRequestHeaders());
        this.mergeConfig(this, that);
        MockHttpServletRequestBuilderInterceptor otherInterceptor = that.getInterceptor();
        if (otherInterceptor != null) {
            this.interceptor = otherInterceptor;
        }
        this.formParams(that.getFormParams());
        this.queryParams(that.getQueryParams());
        this.params(that.getParams());
        this.attributes(that.getAttributes());
        this.multiParts.addAll(that.getMultiParts());
        this.resultHandlers.addAll(that.getResultHandlers());
        this.requestPostProcessors.addAll(that.getRequestPostProcessors());
        RequestLoggingFilter otherRequestLoggingFilter = that.getRequestLoggingFilter();
        if (otherRequestLoggingFilter != null) {
            this.requestLoggingFilter = otherRequestLoggingFilter;
        }
        if ((otherAuth = that.getAuthentication()) != null) {
            this.authentication = otherAuth;
        }
        if ((otherAsyncConfig = that.getAsyncConfig()) != null) {
            this.asyncConfig = otherAsyncConfig;
        }
        return this;
    }

    @Override
    public MockMvcRequestSpecification sessionAttrs(Map<String, Object> sessionAttributes) {
        AssertParameter.notNull(sessionAttributes, (String)"sessionAttributes");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getMockMvcParamConfig().sessionAttributesUpdateStrategy()), sessionAttributes, this.sessionAttributes);
        return this;
    }

    @Override
    public MockMvcRequestSpecification sessionId(String sessionIdValue) {
        return this.sessionId(this.cfg.getSessionConfig().sessionIdName(), sessionIdValue);
    }

    @Override
    public MockMvcRequestSpecification sessionId(String sessionIdName, String sessionIdValue) {
        AssertParameter.notNull((Object)sessionIdName, (String)"Session id name");
        AssertParameter.notNull((Object)sessionIdValue, (String)"Session id value");
        if (this.cookies.hasCookieWithName(sessionIdName)) {
            CookieHelper.sessionId((Cookies)this.cookies, (String)sessionIdName, (String)sessionIdValue);
        } else {
            this.cookie(sessionIdName, sessionIdValue, new Object[0]);
        }
        return this;
    }

    public MockMvcRequestSpecification resultHandlers(ResultHandler resultHandler, ResultHandler ... resultHandlers) {
        AssertParameter.notNull((Object)resultHandler, ResultHandler.class);
        this.resultHandlers.add(resultHandler);
        if (resultHandlers != null && resultHandlers.length >= 1) {
            Collections.addAll(this.resultHandlers, resultHandlers);
        }
        return this;
    }

    @Override
    public MockMvcRequestAsyncSender when() {
        LogConfig logConfig = this.cfg.getLogConfig();
        if (this.requestLoggingFilter == null && logConfig.isLoggingOfRequestAndResponseIfValidationFailsEnabled()) {
            this.log().ifValidationFails(logConfig.logDetailOfRequestAndResponseIfValidationFails(), logConfig.isPrettyPrintingEnabled());
        }
        MockMvc mockMvc = this.mockMvcFactory.build(this.cfg.getMockMvcConfig());
        return new MockMvcRequestSenderImpl(mockMvc, this.params, this.queryParams, this.formParams, this.attributes, this.cfg, this.requestBody, this.requestHeaders, this.cookies, this.sessionAttributes, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository);
    }

    private String serializeIfNeeded(Object object) {
        return Serializer.serializeIfNeeded((Object)object, (String)this.getRequestContentType(), (SpecificationConfig)this.cfg);
    }

    public MockMvcResponse get(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().get(path, pathParams);
    }

    public MockMvcResponse get(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().get(path, pathParams);
    }

    public MockMvcResponse post(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().post(path, pathParams);
    }

    public MockMvcResponse post(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().post(path, pathParams);
    }

    public MockMvcResponse put(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().put(path, pathParams);
    }

    public MockMvcResponse put(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().put(path, pathParams);
    }

    public MockMvcResponse delete(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().delete(path, pathParams);
    }

    public MockMvcResponse delete(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().delete(path, pathParams);
    }

    public MockMvcResponse head(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().head(path, pathParams);
    }

    public MockMvcResponse head(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().head(path, pathParams);
    }

    public MockMvcResponse patch(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().patch(path, pathParams);
    }

    public MockMvcResponse patch(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().patch(path, pathParams);
    }

    public MockMvcResponse options(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().options(path, pathParams);
    }

    public MockMvcResponse options(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().options(path, pathParams);
    }

    public MockMvcResponse get(URI uri) {
        return (MockMvcResponse)this.when().get(uri);
    }

    public MockMvcResponse post(URI uri) {
        return (MockMvcResponse)this.when().post(uri);
    }

    public MockMvcResponse put(URI uri) {
        return (MockMvcResponse)this.when().put(uri);
    }

    public MockMvcResponse delete(URI uri) {
        return (MockMvcResponse)this.when().delete(uri);
    }

    public MockMvcResponse head(URI uri) {
        return (MockMvcResponse)this.when().head(uri);
    }

    public MockMvcResponse patch(URI uri) {
        return (MockMvcResponse)this.when().patch(uri);
    }

    public MockMvcResponse options(URI uri) {
        return (MockMvcResponse)this.when().options(uri);
    }

    public MockMvcResponse get(URL url) {
        return (MockMvcResponse)this.when().get(url);
    }

    public MockMvcResponse post(URL url) {
        return (MockMvcResponse)this.when().post(url);
    }

    public MockMvcResponse put(URL url) {
        return (MockMvcResponse)this.when().put(url);
    }

    public MockMvcResponse delete(URL url) {
        return (MockMvcResponse)this.when().delete(url);
    }

    public MockMvcResponse head(URL url) {
        return (MockMvcResponse)this.when().head(url);
    }

    public MockMvcResponse patch(URL url) {
        return (MockMvcResponse)this.when().patch(url);
    }

    public MockMvcResponse options(URL url) {
        return (MockMvcResponse)this.when().options(url);
    }

    public MockMvcResponse get() {
        return (MockMvcResponse)this.when().get();
    }

    public MockMvcResponse post() {
        return (MockMvcResponse)this.when().post();
    }

    public MockMvcResponse put() {
        return (MockMvcResponse)this.when().put();
    }

    public MockMvcResponse delete() {
        return (MockMvcResponse)this.when().delete();
    }

    public MockMvcResponse head() {
        return (MockMvcResponse)this.when().head();
    }

    public MockMvcResponse patch() {
        return (MockMvcResponse)this.when().patch();
    }

    public MockMvcResponse options() {
        return (MockMvcResponse)this.when().options();
    }

    public MockMvcResponse request(Method method) {
        return (MockMvcResponse)this.when().request(method);
    }

    public MockMvcResponse request(String method) {
        return (MockMvcResponse)this.when().request(method);
    }

    public MockMvcResponse request(Method method, String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().request(method, path, pathParams);
    }

    public MockMvcResponse request(String method, String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().request(method, path, pathParams);
    }

    public MockMvcResponse request(Method method, URI uri) {
        return (MockMvcResponse)this.when().request(method, uri);
    }

    public MockMvcResponse request(Method method, URL url) {
        return (MockMvcResponse)this.when().request(method, url);
    }

    public MockMvcResponse request(String method, URI uri) {
        return (MockMvcResponse)this.when().request(method, uri);
    }

    public MockMvcResponse request(String method, URL url) {
        return (MockMvcResponse)this.when().request(method, url);
    }

    public RestAssuredConfig getRestAssuredConfig() {
        return ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.cfg);
    }

    public void setRequestLoggingFilter(RequestLoggingFilter requestLoggingFilter) {
        this.requestLoggingFilter = requestLoggingFilter;
    }

    private MockMvcRequestSpecification changeMockMvcFactoryTo(MockMvcFactory mockMvcFactory) {
        this.mockMvcFactory = mockMvcFactory;
        return this;
    }

    private void assignConfig(RestAssuredMockMvcConfig config) {
        this.cfg = config == null ? new RestAssuredMockMvcConfig() : config;
    }

    public MockMvcFactory getMockMvcFactory() {
        return this.mockMvcFactory;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Object> getFormParams() {
        return this.formParams;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Object getAuthentication() {
        return this.authentication;
    }

    public RestAssuredMockMvcConfig getRestAssuredMockMvcConfig() {
        return this.cfg;
    }

    public Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public String getRequestContentType() {
        Header header = this.requestHeaders.get(CONTENT_TYPE);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public List<MockMvcMultiPart> getMultiParts() {
        return this.multiParts;
    }

    public RequestLoggingFilter getRequestLoggingFilter() {
        return this.requestLoggingFilter;
    }

    public List<ResultHandler> getResultHandlers() {
        return this.resultHandlers;
    }

    public List<RequestPostProcessor> getRequestPostProcessors() {
        return this.requestPostProcessors;
    }

    public MockHttpServletRequestBuilderInterceptor getInterceptor() {
        return this.interceptor;
    }

    public MockMvcRequestSpecification basePath(String path) {
        AssertParameter.notNull((Object)path, (String)"Base path");
        this.basePath = path;
        return this;
    }

    @Override
    public MockMvcRequestSpecification principal(Principal principal) {
        AssertParameter.notNull((Object)principal, Principal.class);
        this.authentication = principal;
        return this;
    }

    @Override
    public MockMvcRequestSpecification with(RequestPostProcessor requestPostProcessor, RequestPostProcessor ... additionalRequestPostProcessor) {
        AssertParameter.notNull((Object)requestPostProcessor, RequestPostProcessor.class);
        this.authentication = null;
        this.requestPostProcessors.add(requestPostProcessor);
        if (additionalRequestPostProcessor != null && additionalRequestPostProcessor.length != 0) {
            this.requestPostProcessors.addAll(Arrays.asList(additionalRequestPostProcessor));
        }
        return this;
    }

    @Override
    public MockMvcRequestSpecification principal(Object principal) {
        return this.principalWithCredentials(principal, "", new String[0]);
    }

    @Override
    public MockMvcRequestSpecification principalWithCredentials(Object principal, Object credentials, String ... authorities) {
        return this.authentication(new TestingAuthenticationToken(principal, credentials, authorities));
    }

    @Override
    public MockMvcRequestSpecification authentication(Object authentication) {
        if (!SpringSecurityClassPathChecker.isSpringSecurityInClasspath()) {
            throw new IllegalArgumentException("Cannot use this authentication method since Spring Security was not found in classpath.");
        }
        AssertParameter.notNull((Object)authentication, Authentication.class);
        if (!(authentication instanceof Authentication)) {
            throw new IllegalArgumentException("authentication object must be an instance of " + Authentication.class.getName());
        }
        this.authentication = authentication;
        return this;
    }

    @Override
    public MockMvcRequestSpecification none() {
        this.authentication = null;
        return this;
    }

    public LogRepository getLogRepository() {
        return this.logRepository;
    }

    public AsyncConfig getAsyncConfig() {
        return this.asyncConfig;
    }

    @Override
    public MockMvcRequestSpecification sessionAttr(String name, Object value) {
        AssertParameter.notNull((Object)name, (String)"Session attribute name");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getMockMvcParamConfig().sessionAttributesUpdateStrategy()), this.sessionAttributes, name, new Object[]{value});
        return this;
    }

    private void mergeConfig(MockMvcRequestSpecificationImpl thisOne, MockMvcRequestSpecificationImpl other) {
        this.config((RestAssuredMockMvcConfig)ConfigMergeUtils.mergeConfig((SpecificationConfig)thisOne.getRestAssuredMockMvcConfig(), (SpecificationConfig)other.getRestAssuredMockMvcConfig()));
    }
}

