/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.util.ReflectionUtils;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T invokeMethod(Object instance, String methodName, Object ... arguments) {
        Class<?>[] argumentTypes = ReflectionUtil.getArgumentTypes(arguments);
        return ReflectionUtil.invokeMethod(instance, methodName, argumentTypes, arguments);
    }

    public static <T> T invokeMethod(Object instance, String methodName, Class<?>[] argumentTypes, Object ... arguments) {
        Method method = ReflectionUtils.findMethod(instance instanceof Class ? (Class<?>)instance : instance.getClass(), (String)methodName, (Class[])argumentTypes);
        if (method == null) {
            throw new IllegalArgumentException("Cannot find method '" + methodName + "' in " + instance.getClass() + " (arguments=" + Arrays.toString(arguments) + ")");
        }
        ReflectionUtils.makeAccessible((Method)method);
        if (!method.isVarArgs() || argumentTypes.length == 0 || argumentTypes.length == arguments.length && Objects.equals(argumentTypes[argumentTypes.length - 1], arguments[arguments.length - 1].getClass())) {
            return (T)ReflectionUtils.invokeMethod((Method)method, (Object)instance, (Object[])arguments);
        }
        Object[] objectArrayNeededForInvocation = new Object[argumentTypes.length];
        Object varArgsArguments = ReflectionUtil.getVarArgsArguments(argumentTypes, arguments);
        System.arraycopy(arguments, 0, objectArrayNeededForInvocation, 0, argumentTypes.length - 1);
        objectArrayNeededForInvocation[objectArrayNeededForInvocation.length - 1] = varArgsArguments;
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)instance, (Object[])objectArrayNeededForInvocation);
    }

    public static <T> T invokeConstructor(String className, Object ... arguments) {
        Class<?>[] argumentTypes = ReflectionUtil.getArgumentTypes(arguments);
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> constructor = cls.getConstructor(argumentTypes);
            return (T)constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?>[] getArgumentTypes(Object[] arguments) {
        Class[] argumentTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argumentTypes[i] = arguments[i].getClass();
        }
        return argumentTypes;
    }

    private static Object getVarArgsArguments(Class<?>[] argumentTypes, Object[] arguments) {
        Class<?> argumentType = argumentTypes[argumentTypes.length - 1];
        if (argumentType.isArray()) {
            argumentType = argumentType.getComponentType();
        }
        int numberOfVarArgParameters = arguments.length - argumentTypes.length + 1;
        Object varArgsArguments = Array.newInstance(argumentType, numberOfVarArgParameters);
        int j = 0;
        int i = argumentTypes.length - 1;
        while (i < arguments.length) {
            Array.set(varArgsArguments, j, arguments[i]);
            ++i;
            ++j;
        }
        return varArgsArguments;
    }
}

