/*
 * Decompiled with CFR 0.152.
 */
package restx.exceptions;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Named;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.exceptions.ErrorDescriptor;
import restx.factory.Component;
import restx.jackson.StdJsonProducerEntityRoute;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;

@Component
public class ErrorDescriptorsRoute
extends StdJsonProducerEntityRoute {
    private final ImmutableMap<String, ErrorDescriptor> errorDescriptors;
    private final RestxSecurityManager securityManager;
    private PermissionFactory permissionFactory;

    public ErrorDescriptorsRoute(Iterable<ErrorDescriptor> errorDescriptors, @Named(value="FrontObjectWriter") ObjectWriter objectWriter, RestxSecurityManager securityManager, PermissionFactory permissionFactory, EndpointParameterMapperRegistry registry) {
        super("ErrorDescriptorsRoute", ImmutableCollection.class, objectWriter, Endpoint.of((String)"GET", (String)"/@/errors/descriptors"), permissionFactory, registry);
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (ErrorDescriptor errorDescriptor : errorDescriptors) {
            if (map.containsKey(errorDescriptor.getErrorCode())) {
                throw new IllegalStateException("duplicate error code found: " + errorDescriptor.getErrorCode());
            }
            map.put(errorDescriptor.getErrorCode(), errorDescriptor);
        }
        this.errorDescriptors = ImmutableMap.copyOf((Map)map);
        this.securityManager = securityManager;
    }

    protected Optional<?> doRoute(RestxRequest restxRequest, RestxResponse response, RestxRequestMatch match, Object i) throws IOException {
        this.securityManager.check(restxRequest, match, this.permissionFactory.hasRole("restx-admin"));
        return Optional.of((Object)this.errorDescriptors.values());
    }
}

