/*
 * Decompiled with CFR 0.152.
 */
package restx.exceptions;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableSet;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.exceptions.ErrorDescriptor;
import restx.exceptions.ErrorDescriptorsRoute;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;

@Machine
public class ErrorDescriptorsRouteFactoryMachine
extends SingleNameFactoryMachine<ErrorDescriptorsRoute> {
    public static final Name<ErrorDescriptorsRoute> NAME = Name.of(ErrorDescriptorsRoute.class, (String)"ErrorDescriptorsRoute");

    public ErrorDescriptorsRouteFactoryMachine() {
        super(0, (MachineEngine)new StdMachineEngine<ErrorDescriptorsRoute>(NAME, 0, BoundlessComponentBox.FACTORY){
            private final Factory.Query<ErrorDescriptor> errorDescriptors = Factory.Query.byClass(ErrorDescriptor.class).optional();
            private final Factory.Query<ObjectWriter> objectWriter = Factory.Query.byName((Name)Name.of(ObjectWriter.class, (String)"FrontObjectWriter")).mandatory();
            private final Factory.Query<RestxSecurityManager> securityManager = Factory.Query.byClass(RestxSecurityManager.class).mandatory();
            private final Factory.Query<PermissionFactory> permissionFactory = Factory.Query.byClass(PermissionFactory.class).mandatory();
            private final Factory.Query<EndpointParameterMapperRegistry> registry = Factory.Query.byClass(EndpointParameterMapperRegistry.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.errorDescriptors, this.objectWriter, this.securityManager, this.permissionFactory, this.registry));
            }

            protected ErrorDescriptorsRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new ErrorDescriptorsRoute(satisfiedBOM.getAsComponents(this.errorDescriptors), (ObjectWriter)((NamedComponent)satisfiedBOM.getOne(this.objectWriter).get()).getComponent(), (RestxSecurityManager)((NamedComponent)satisfiedBOM.getOne(this.securityManager).get()).getComponent(), (PermissionFactory)((NamedComponent)satisfiedBOM.getOne(this.permissionFactory).get()).getComponent(), (EndpointParameterMapperRegistry)((NamedComponent)satisfiedBOM.getOne(this.registry).get()).getComponent());
            }
        });
    }
}

