/*
 * Decompiled with CFR 0.152.
 */
package restx.classloader;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColdClasses {
    private static final Logger logger = LoggerFactory.getLogger(ColdClasses.class);
    public static final String COLD_CLASSES_FILE_PATH = "META-INF/cold-classes.list";

    private ColdClasses() {
    }

    public static ImmutableSet<Class<?>> extractFromString(ClassLoader classLoader, String coldClasses) {
        ImmutableSet.Builder classes = ImmutableSet.builder();
        for (String fqcn : Splitter.on((char)',').trimResults().split((CharSequence)coldClasses)) {
            try {
                classes.add(classLoader.loadClass(fqcn));
            }
            catch (ClassNotFoundException e) {
                logger.warn("invalid cold class {}: unable to find it from supplied classloader", (Object)fqcn);
            }
        }
        return classes.build();
    }

    public static ImmutableSet<Class<?>> extractFromResources(ClassLoader classLoader) throws IOException {
        ImmutableSet.Builder classes = ImmutableSet.builder();
        Enumeration<URL> resources = classLoader.getResources(COLD_CLASSES_FILE_PATH);
        while (resources.hasMoreElements()) {
            for (String fqcn : Resources.readLines((URL)resources.nextElement(), (Charset)Charsets.UTF_8)) {
                try {
                    classes.add(classLoader.loadClass(fqcn));
                }
                catch (ClassNotFoundException e) {
                    logger.warn("invalid cold class {}: unable to find it from supplied classloader", (Object)fqcn);
                }
            }
        }
        return classes.build();
    }
}

