/*
 * Decompiled with CFR 0.152.
 */
package restx.classloader;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.classloader.ClasspathResourceEvent;
import restx.classloader.CompilationFinishedEvent;
import restx.classloader.CompilationSettings;
import restx.classloader.HotReloadingClassLoader;
import restx.common.MoreFiles;
import restx.common.watch.FileWatchEvent;
import restx.common.watch.WatcherSettings;

public class CompilationManager
implements Closeable {
    private static final Runnable NO_OP = new Runnable(){

        @Override
        public void run() {
        }
    };
    public static final Predicate<Path> DEFAULT_CLASSPATH_RESOURCE_FILTER = new Predicate<Path>(){

        public boolean apply(Path path) {
            return !path.toString().endsWith("___jb_old___") && !path.toString().endsWith("___jb_bak___") && path.toAbsolutePath().toString().replace('\\', '/').indexOf("/.svn/") == -1;
        }
    };
    public static final CompilationSettings DEFAULT_SETTINGS = new CompilationSettings(){

        @Override
        public int autoCompileCoalescePeriod() {
            return 50;
        }

        @Override
        public Predicate<Path> classpathResourceFilter() {
            return DEFAULT_CLASSPATH_RESOURCE_FILTER;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(CompilationManager.class);
    private final EventBus eventBus;
    private final Predicate<Path> classpathResourceFilter;
    private final JavaCompiler javaCompiler;
    private final Iterable<Path> sourceRoots;
    private final Path destination;
    private final CompilationSettings settings;
    private final StandardJavaFileManager fileManager;
    private final ScheduledExecutorService compileExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentLinkedDeque<Path> compileQueue = new ConcurrentLinkedDeque();
    private final Map<Path, SourceHash> hashes = new HashMap<Path, SourceHash>();
    private ExecutorService watcherExecutor;
    private final List<Closeable> closeableWatchers = new ArrayList<Closeable>();
    private volatile boolean compiling;
    private final long compilationTimeout = 60L;
    private final int autoCompileQuietPeriod = 50;
    private final boolean useLastModifiedTocheckChanges = true;
    private Collection<Diagnostic<?>> lastDiagnostics = new CopyOnWriteArrayList();
    private static final AtomicLong CLASSLOADER_COUNT = new AtomicLong();

    public CompilationManager(EventBus eventBus, Iterable<Path> sourceRoots, Path destination) {
        this(eventBus, sourceRoots, destination, DEFAULT_SETTINGS);
    }

    public CompilationManager(EventBus eventBus, Iterable<Path> sourceRoots, Path destination, CompilationSettings settings) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.sourceRoots = (Iterable)Preconditions.checkNotNull(sourceRoots);
        this.destination = (Path)Preconditions.checkNotNull((Object)destination);
        this.classpathResourceFilter = (Predicate)Preconditions.checkNotNull(settings.classpathResourceFilter());
        this.settings = settings;
        this.javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (this.javaCompiler == null) {
            throw new IllegalStateException("trying to setup a compilation manager while no system compiler is available. This should be prevented by checking the system java compiler first.");
        }
        this.fileManager = this.javaCompiler.getStandardFileManager(new DiagnosticCollector(), Locale.ENGLISH, Charsets.UTF_8);
        try {
            if (!destination.toFile().exists()) {
                destination.toFile().mkdirs();
            }
            this.fileManager.setLocation(StandardLocation.SOURCE_PATH, Iterables.transform(sourceRoots, (Function)MoreFiles.pathToFile));
            this.fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(destination.toFile()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.loadHashes();
        eventBus.register(new Object(){

            @Subscribe
            public void onWatchEvent(FileWatchEvent event) {
                WatchEvent.Kind kind = event.getKind();
                Path source = event.getDir().resolve(event.getPath());
                if (!source.toFile().isFile()) {
                    return;
                }
                if (CompilationManager.this.isSource(source)) {
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        if (!CompilationManager.this.queueCompile(source)) {
                            CompilationManager.this.rebuild();
                        }
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        CompilationManager.this.rebuild();
                    } else {
                        CompilationManager.this.rebuild();
                    }
                } else {
                    Optional<SourcePath> sourcePath = SourcePath.resolve(CompilationManager.this.sourceRoots, source);
                    if (sourcePath.isPresent()) {
                        logger.info("classpath resource updated: {}", (Object)((SourcePath)sourcePath.get()).getPath());
                        CompilationManager.this.copyResource((SourcePath)sourcePath.get());
                    }
                }
            }
        });
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Path getDestination() {
        return this.destination;
    }

    public Iterable<Path> getSourceRoots() {
        return this.sourceRoots;
    }

    private void copyResource(final SourcePath resourcePath) {
        this.compileExecutor.submit(new Runnable(){

            @Override
            public void run() {
                CompilationManager.this.doCopyResource(resourcePath);
            }
        });
    }

    private void doCopyResource(SourcePath resourcePath) {
        File source = resourcePath.toAbsolutePath().toFile();
        if (source.isFile() && this.classpathResourceFilter.apply((Object)source.toPath())) {
            try {
                File to = this.destination.resolve(resourcePath.getPath()).toFile();
                to.getParentFile().mkdirs();
                boolean existed = to.exists();
                if (!existed || to.lastModified() < source.lastModified()) {
                    com.google.common.io.Files.copy((File)source, (File)to);
                    ClasspathResourceEvent.Kind kind = existed ? ClasspathResourceEvent.Kind.UPDATED : ClasspathResourceEvent.Kind.CREATED;
                    this.eventBus.post((Object)new ClasspathResourceEvent(kind, resourcePath.getPath().toString()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean queueCompile(final Path source) {
        boolean b = this.compileQueue.offerLast(source);
        if (!b) {
            return false;
        }
        this.compileExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                if (CompilationManager.this.compileQueue.getLast() == source) {
                    HashSet<Path> sources = new HashSet<Path>();
                    while (!CompilationManager.this.compileQueue.isEmpty()) {
                        sources.add(CompilationManager.this.compileQueue.removeFirst());
                    }
                    CompilationManager.this.compile(sources);
                }
            }
        }, 50L, TimeUnit.MILLISECONDS);
        return true;
    }

    public Optional<Path> getClassFile(String className) {
        Path classFilePath = this.destination.resolve(className.replace('.', '/') + ".class");
        if (classFilePath.toFile().exists()) {
            return Optional.of((Object)classFilePath);
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAutoCompile() {
        CompilationManager compilationManager = this;
        synchronized (compilationManager) {
            if (this.watcherExecutor == null) {
                this.watcherExecutor = Executors.newCachedThreadPool();
                ArrayList<Path> watched = new ArrayList<Path>();
                for (Path sourceRoot : this.sourceRoots) {
                    if (sourceRoot.toFile().exists()) {
                        watched.add(sourceRoot);
                        this.closeableWatchers.add(MoreFiles.watch((Path)sourceRoot, (EventBus)this.eventBus, (ExecutorService)this.watcherExecutor, (WatcherSettings)new WatcherSettings(){

                            public int coalescePeriod() {
                                return CompilationManager.this.settings.autoCompileCoalescePeriod();
                            }

                            public boolean recurse() {
                                return true;
                            }
                        }));
                        continue;
                    }
                    logger.info("source root {} does not exist - IGNORED", (Object)sourceRoot);
                }
                logger.info("watching for changes in {}; current location is {}", watched, (Object)new File(".").getAbsoluteFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAutoCompile() {
        CompilationManager compilationManager = this;
        synchronized (compilationManager) {
            if (this.watcherExecutor != null) {
                this.watcherExecutor.shutdownNow();
                this.watcherExecutor = null;
            }
            if (this.closeableWatchers.size() > 0) {
                for (Closeable closeableWatcher : this.closeableWatchers) {
                    try {
                        closeableWatcher.close();
                    }
                    catch (IOException iOException) {}
                }
                this.closeableWatchers.clear();
            }
        }
    }

    public void awaitAutoCompile() {
        try {
            if (this.compileQueue.isEmpty()) {
                this.compileExecutor.submit(NO_OP).get(60L, TimeUnit.SECONDS);
            } else {
                this.compileExecutor.schedule(NO_OP, 60L, TimeUnit.MILLISECONDS).get(60L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void incrementalCompile() {
        try {
            Exception e = this.compileExecutor.submit(new Callable<Exception>(){

                @Override
                public Exception call() throws Exception {
                    try {
                        final ArrayList<Path> sources = new ArrayList<Path>();
                        for (final Path sourceRoot : CompilationManager.this.sourceRoots) {
                            if (!sourceRoot.toFile().exists()) continue;
                            Files.walkFileTree(sourceRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    if (CompilationManager.this.isSource(file)) {
                                        if (CompilationManager.this.hasSourceChanged(sourceRoot, sourceRoot.relativize(file))) {
                                            sources.add(file);
                                        }
                                    } else if (file.toFile().isFile()) {
                                        CompilationManager.this.doCopyResource(SourcePath.valueOf(sourceRoot, sourceRoot.relativize(file)));
                                    }
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                        CompilationManager.this.compile(sources);
                        return null;
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
            }).get(60L, TimeUnit.SECONDS);
            if (e != null) {
                throw new RuntimeException(e);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSource(Path file) {
        return file.toString().endsWith(".java");
    }

    public void rebuild() {
        try {
            Exception e = this.compileExecutor.submit(new Callable<Exception>(){

                @Override
                public Exception call() throws Exception {
                    try {
                        CompilationManager.this.compileQueue.clear();
                        MoreFiles.delete((Path)CompilationManager.this.destination);
                        CompilationManager.this.destination.toFile().mkdirs();
                        final ArrayList<Path> sources = new ArrayList<Path>();
                        for (final Path sourceRoot : CompilationManager.this.sourceRoots) {
                            if (!sourceRoot.toFile().exists()) continue;
                            Files.walkFileTree(sourceRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    if (CompilationManager.this.isSource(file)) {
                                        sources.add(file);
                                    } else if (file.toFile().isFile()) {
                                        CompilationManager.this.doCopyResource(SourcePath.valueOf(sourceRoot, sourceRoot.relativize(file)));
                                    }
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                        CompilationManager.this.compile(sources);
                        return null;
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
            }).get(60L, TimeUnit.SECONDS);
            if (e != null) {
                throw new RuntimeException(e);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void compileSources(final Path ... sources) {
        try {
            Exception e = this.compileExecutor.submit(new Callable<Exception>(){

                @Override
                public Exception call() throws Exception {
                    CompilationManager.this.compile(Arrays.asList(sources));
                    return null;
                }
            }).get(60L, TimeUnit.SECONDS);
            if (e != null) {
                throw new RuntimeException(e);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<Diagnostic<?>> getLastDiagnostics() {
        return Collections.unmodifiableCollection(this.lastDiagnostics);
    }

    public HotReloadingClassLoader newHotReloadingClassLoader(String rootPackage, ImmutableSet<Class> coldClasses) {
        try {
            CLASSLOADER_COUNT.incrementAndGet();
            final String name = "HotCompile[" + CLASSLOADER_COUNT + "]";
            final Path destinationDir = this.getDestination();
            return new HotReloadingClassLoader(new URLClassLoader(new URL[]{destinationDir.toUri().toURL()}, Thread.currentThread().getContextClassLoader()), rootPackage, coldClasses){

                @Override
                protected InputStream getInputStream(String path) {
                    try {
                        return Files.newInputStream(destinationDir.resolve(path), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                public String toString() {
                    return name;
                }
            };
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void compile(Collection<Path> sources) {
        block11: {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.compiling = true;
            try {
                this.lastDiagnostics.clear();
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                Iterable<? extends JavaFileObject> javaFileObjects = this.fileManager.getJavaFileObjectsFromFiles(Iterables.transform(sources, (Function)MoreFiles.pathToFile));
                if (Iterables.isEmpty(javaFileObjects)) {
                    logger.debug("compilation finished: up to date");
                    return;
                }
                JavaCompiler.CompilationTask compilationTask = this.javaCompiler.getTask(null, this.fileManager, diagnostics, Arrays.asList("-g"), null, javaFileObjects);
                boolean valid = compilationTask.call();
                if (valid) {
                    for (Path path : sources) {
                        Optional<SourcePath> sourcePath = SourcePath.resolve(this.sourceRoots, path);
                        if (!sourcePath.isPresent()) continue;
                        SourceHash sourceHash = this.newSourceHashFor((SourcePath)sourcePath.get());
                        this.hashes.put(path.toAbsolutePath(), sourceHash);
                    }
                    this.saveHashes();
                    logger.info("compilation finished: {} sources compiled in {}", (Object)sources.size(), (Object)stopwatch.stop());
                    this.eventBus.post((Object)new CompilationFinishedEvent(this, DateTime.now(), (ImmutableCollection<Path>)ImmutableList.copyOf(sources)));
                    for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                        logger.debug("{}", (Object)diagnostic);
                    }
                    break block11;
                }
                StringBuilder sb = new StringBuilder();
                for (Diagnostic d : diagnostics.getDiagnostics()) {
                    sb.append(d).append("\n");
                }
                this.lastDiagnostics.addAll(diagnostics.getDiagnostics());
                throw new RuntimeException("Compilation failed:\n" + sb);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.compiling = false;
            }
        }
    }

    private void saveHashes() {
        File hashesFile = this.hashesFile();
        hashesFile.getParentFile().mkdirs();
        try (BufferedWriter w = com.google.common.io.Files.newWriter((File)hashesFile, (Charset)Charsets.UTF_8);){
            for (SourceHash sourceHash : this.hashes.values()) {
                w.write(sourceHash.serializeAsString());
                w.write("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadHashes() {
        File hashesFile = this.hashesFile();
        if (hashesFile.exists()) {
            try (BufferedReader r = com.google.common.io.Files.newReader((File)hashesFile, (Charset)Charsets.UTF_8);){
                String line;
                while ((line = r.readLine()) != null) {
                    SourceHash sourceHash = this.parse(line);
                    this.hashes.put(sourceHash.getSourcePath().toAbsolutePath(), sourceHash);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private File hashesFile() {
        return this.destination.resolve("META-INF/.hashes").toFile();
    }

    public boolean isCompiling() {
        return this.compiling;
    }

    private boolean hasSourceChanged(Path dir, Path source) {
        try {
            SourceHash sourceHash = this.hashes.get(dir.resolve(source).toAbsolutePath());
            if (sourceHash != null) {
                return sourceHash.hasChanged() != sourceHash;
            }
            return true;
        }
        catch (IOException e) {
            return true;
        }
    }

    private SourceHash newSourceHashFor(SourcePath sourcePath) throws IOException {
        File sourceFile = sourcePath.toAbsolutePath().toFile();
        return new SourceHash(sourcePath, this.hash(sourceFile), sourceFile.lastModified());
    }

    private String hash(File file) throws IOException {
        return com.google.common.io.Files.hash((File)file, (HashFunction)Hashing.md5()).toString();
    }

    private SourceHash parse(String str) {
        Iterator parts = Splitter.on((String)"**").split((CharSequence)str).iterator();
        FileSystem fileSystem = FileSystems.getDefault();
        return new SourceHash(SourcePath.valueOf(fileSystem.getPath((String)parts.next(), new String[0]), fileSystem.getPath((String)parts.next(), new String[0])), (String)parts.next(), Long.parseLong((String)parts.next()));
    }

    @Override
    public void close() throws IOException {
        this.stopAutoCompile();
        this.compileExecutor.shutdownNow();
    }

    private static class SourcePath {
        private final Path sourceDir;
        private final Path path;

        public static Optional<SourcePath> resolve(Iterable<Path> sourceRoots, Path source) {
            Path dir = null;
            for (Path sourceRoot : sourceRoots) {
                if ((!source.isAbsolute() || !source.startsWith(sourceRoot.toAbsolutePath())) && (source.isAbsolute() || !source.startsWith(sourceRoot))) continue;
                dir = sourceRoot;
                break;
            }
            if (dir == null) {
                logger.warn("can't find sourceRoot for {}", (Object)source);
                return Optional.absent();
            }
            return Optional.of((Object)new SourcePath(dir, source.isAbsolute() ? dir.toAbsolutePath().relativize(source) : dir.relativize(source)));
        }

        public static SourcePath valueOf(Path sourceRoot, Path path) {
            return new SourcePath(sourceRoot, path);
        }

        private SourcePath(Path sourceDir, Path path) {
            this.sourceDir = sourceDir;
            this.path = path;
        }

        public Path getSourceDir() {
            return this.sourceDir;
        }

        public Path getPath() {
            return this.path;
        }

        public Path toAbsolutePath() {
            return this.sourceDir.resolve(this.path).toAbsolutePath();
        }

        public String toString() {
            return "SourcePath{sourceDir=" + this.sourceDir + ", path=" + this.path + "}";
        }
    }

    private class SourceHash {
        private final SourcePath sourcePath;
        private final String hash;
        private final long lastModified;

        private SourceHash(SourcePath sourcePath, String hash, long lastModified) {
            this.sourcePath = sourcePath;
            this.hash = hash;
            this.lastModified = lastModified;
        }

        public String toString() {
            return "SourceHash{sourcePath=" + this.sourcePath + ", hash='" + this.hash + "', lastModified=" + this.lastModified + "}";
        }

        public SourcePath getSourcePath() {
            return this.sourcePath;
        }

        public String getHash() {
            return this.hash;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public SourceHash hasChanged() throws IOException {
            File sourceFile = this.sourcePath.toAbsolutePath().toFile();
            if (this.lastModified < sourceFile.lastModified()) {
                return new SourceHash(this.sourcePath, this.computeHash(), sourceFile.lastModified());
            }
            return this;
        }

        private String computeHash() throws IOException {
            return CompilationManager.this.hash(this.sourcePath.toAbsolutePath().toFile());
        }

        public String serializeAsString() throws IOException {
            return Joiner.on((String)"**").join((Object)this.sourcePath.getSourceDir(), (Object)this.sourcePath.getPath(), new Object[]{this.hash, this.lastModified});
        }
    }
}

