/*
 * Decompiled with CFR 0.152.
 */
package restx.classloader;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class HotReloadingClassLoader
extends ClassLoader {
    private final String rootPackageName;
    private final ImmutableMap<String, Class> coldClasses;

    public HotReloadingClassLoader(ClassLoader parentClassLoader, String rootPackageName, ImmutableSet<Class> coldClasses) throws NullPointerException {
        super(parentClassLoader);
        if (rootPackageName == null) {
            throw new NullPointerException("The rootPackageName parameter is null.");
        }
        this.rootPackageName = rootPackageName;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class coldClass : coldClasses) {
            builder.put((Object)coldClass.getName(), (Object)coldClass);
        }
        this.coldClasses = builder.build();
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.isTarget(className)) {
            String packageName;
            Class<?> clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            clazz = (Class<?>)this.coldClasses.get((Object)className);
            if (clazz != null) {
                return clazz;
            }
            int index = className.lastIndexOf(46);
            if (index >= 0 && this.getPackage(packageName = className.substring(0, index)) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((clazz = this.defineClass(className, resolve)) != null) {
                return clazz;
            }
        }
        return super.loadClass(className, resolve);
    }

    protected Class<?> defineClass(String className, boolean resolve) {
        String path = className.replace('.', '/') + ".class";
        InputStream is = this.getInputStream(path);
        if (is != null) {
            Class<?> clazz = this.defineClass(className, is);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return null;
    }

    protected Class<?> defineClass(String className, InputStream is) {
        return this.defineClass(className, this.getBytes(is));
    }

    protected Class<?> defineClass(String className, byte[] bytes) {
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    protected InputStream getInputStream(String path) {
        try {
            URL url = this.getResource(path);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ignore) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytes(InputStream is) throws RuntimeException {
        byte[] bytes = null;
        byte[] buf = new byte[8192];
        try {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int n = 0;
                while ((n = is.read(buf, 0, buf.length)) != -1) {
                    baos.write(buf, 0, n);
                }
                bytes = baos.toByteArray();
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    protected boolean isTarget(String className) {
        return className.startsWith(this.rootPackageName + ".");
    }
}

