/*
 * Decompiled with CFR 0.152.
 */
package restx.classloader.processor;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import restx.classloader.Cold;
import restx.common.processor.RestxAbstractProcessor;

@SupportedAnnotationTypes(value={"restx.classloader.Cold"})
@SupportedOptions(value={"debug"})
public class ColdClassesAnnotationProcessor
extends RestxAbstractProcessor {
    private final ColdClassesDeclaration coldClassesDeclaration = new ColdClassesDeclaration();

    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        this.coldClassesDeclaration.processing();
        if (roundEnv.processingOver()) {
            this.coldClassesDeclaration.generate();
        } else {
            this.processColdClasses(roundEnv);
        }
        return true;
    }

    private void processColdClasses(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Cold.class)) {
            if (!(element instanceof TypeElement)) {
                this.error("annotating element " + element + " of type " + element.getKind().name() + " with @Cold is not supported", element);
                continue;
            }
            TypeElement typeElem = (TypeElement)element;
            this.coldClassesDeclaration.declareColdClass(typeElem.getQualifiedName().toString());
        }
    }

    private class ColdClassesDeclaration
    extends RestxAbstractProcessor.ResourceDeclaration {
        private final Set<String> coldClasses;

        protected ColdClassesDeclaration() {
            super((RestxAbstractProcessor)ColdClassesAnnotationProcessor.this, "META-INF/cold-classes.list");
            this.coldClasses = Sets.newHashSet();
        }

        void declareColdClass(String coldClass) {
            this.coldClasses.add(coldClass);
        }

        protected boolean requireGeneration() {
            return this.coldClasses.size() > 0;
        }

        protected void clearContent() {
            this.coldClasses.clear();
        }

        protected void writeContent(Writer writer) throws IOException {
            writer.write(Joiner.on((char)'\n').join((Iterable)Ordering.natural().sortedCopy(this.coldClasses)));
            writer.write(10);
        }

        protected void readContent(Reader reader) throws IOException {
            this.coldClasses.addAll(CharStreams.readLines((Readable)reader));
        }
    }
}

