/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Optional;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AggregateType {
    ITERABLE{

        @Override
        public boolean isApplicableTo(String fqcn) {
            return 1.matchesParameterizedFQCN(Iterable.class, fqcn);
        }

        @Override
        public <T> Object createFrom(List values, Class<T> itemClass) {
            return values;
        }
    }
    ,
    LIST{

        @Override
        public boolean isApplicableTo(String fqcn) {
            return 2.matchesParameterizedFQCN(List.class, fqcn);
        }

        @Override
        public <T> Object createFrom(List values, Class<T> itemClass) {
            return values;
        }
    }
    ,
    SET{

        @Override
        public boolean isApplicableTo(String fqcn) {
            return 3.matchesParameterizedFQCN(Set.class, fqcn);
        }

        @Override
        public <T> Object createFrom(List values, Class<T> itemClass) {
            return Sets.newHashSet((Iterable)values);
        }
    }
    ,
    COLLECTION{

        @Override
        public boolean isApplicableTo(String fqcn) {
            return 4.matchesParameterizedFQCN(Collection.class, fqcn);
        }

        @Override
        public <T> Object createFrom(List values, Class<T> itemClass) {
            return values;
        }
    }
    ,
    ARRAY{

        @Override
        public boolean isApplicableTo(String fqcn) {
            return fqcn.endsWith("[]");
        }

        @Override
        public <T> Object createFrom(List values, Class<T> itemClass) {
            return values.toArray(ObjectArrays.newArray(itemClass, (int)values.size()));
        }
    };


    public static Optional<AggregateType> fromType(String fqcn) {
        for (AggregateType aggregateType : AggregateType.values()) {
            if (!aggregateType.isApplicableTo(fqcn)) continue;
            return Optional.of((Object)((Object)aggregateType));
        }
        return Optional.absent();
    }

    public abstract boolean isApplicableTo(String var1);

    public abstract <T> Object createFrom(List var1, Class<T> var2);

    protected static boolean matchesParameterizedFQCN(Class c, String fqcn) {
        return fqcn.startsWith(c.getCanonicalName());
    }

    public static boolean isAggregate(String fqcn) {
        return AggregateType.fromType(fqcn).isPresent();
    }

    public static Class aggregatedTypeOf(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            return ((Class)type).getComponentType();
        }
        throw new IllegalArgumentException("Call to aggregatedTypeOf() is not supported for type : " + type);
    }
}

