/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Function;
import com.google.common.eventbus.EventBus;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import restx.common.watch.WatcherServiceLoader;
import restx.common.watch.WatcherSettings;

public class MoreFiles {
    public static final Function<? super Path, ? extends File> pathToFile = new Function<Path, File>(){

        public File apply(Path input) {
            return input.toFile();
        }
    };
    public static final Function<String, Path> strToPath = new Function<String, Path>(){

        public Path apply(String input) {
            return FileSystems.getDefault().getPath(input, new String[0]);
        }
    };

    public static void delete(Path path) throws IOException {
        if (path.toFile().isDirectory()) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        } else {
            Files.deleteIfExists(path);
        }
    }

    public static Closeable watch(Path dir, EventBus eventBus, ExecutorService executor, WatcherSettings watcherSettings) {
        return WatcherServiceLoader.getWatcherService().watch(eventBus, executor, dir, watcherSettings);
    }

    public static void copyDir(final Path sourceDir, final Path targetDir) throws IOException {
        Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path target = targetDir.resolve(sourceDir.relativize(file));
                File targetDir2 = target.getParent().toAbsolutePath().toFile();
                if (!targetDir2.exists() && !targetDir2.mkdirs()) {
                    throw new IOException("can't create directory: `" + targetDir2 + "`");
                }
                Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void checkFileExists(String location) {
        File file = new File(location);
        if (!file.exists()) {
            String workingDir = "<unknown location>";
            try {
                workingDir = new File(".").getAbsoluteFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalStateException("couldn't find " + location + " in " + workingDir + "\nCheck your working directory.\n");
        }
    }

    public static void extractZip(File zip, File toDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File file = new File(toDir, entry.getName());
                com.google.common.io.Files.createParentDirs((File)file);
                Files.copy(zis, file.toPath(), new CopyOption[0]);
                zis.closeEntry();
            }
        }
    }

    public static String removeWindowsCarriageReturnsBeforeLF(String str) {
        return str.replaceAll("\r\n", "\n");
    }
}

