/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Locale;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.format.PeriodFormatterBuilder;
import org.joda.time.format.PeriodParser;

public class MorePeriods {
    private static final PeriodParser PERIOD_PARSER = new PeriodFormatterBuilder().appendYears().appendSuffix("y").appendSeparatorIfFieldsAfter(" ").appendMonths().appendSuffix("mo").appendSeparatorIfFieldsAfter(" ").appendWeeks().appendSuffix("w").appendSeparatorIfFieldsAfter(" ").appendDays().appendSuffix("d").appendSeparatorIfFieldsAfter(" ").appendHours().appendSuffix("h").appendSeparatorIfFieldsAfter(" ").appendMinutes().appendSuffix("m").appendSeparatorIfFieldsAfter(" ").appendSeconds().appendSuffix("s").toParser();
    private static final LoadingCache<ParseableDurationForLocale, Period> PARSED_PERIODS_CACHE = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<ParseableDurationForLocale, Period>(){

        public Period load(ParseableDurationForLocale parseableDurationForLocale) throws Exception {
            MutablePeriod period = new MutablePeriod();
            PERIOD_PARSER.parseInto((ReadWritablePeriod)period, parseableDurationForLocale.duration, 0, parseableDurationForLocale.locale);
            return period.toPeriod();
        }
    });

    public static Period parsePeriod(String duration, Locale currentLocale) {
        return (Period)PARSED_PERIODS_CACHE.getUnchecked((Object)new ParseableDurationForLocale(duration, currentLocale));
    }

    private static class ParseableDurationForLocale {
        String duration;
        Locale locale;

        public ParseableDurationForLocale(String duration, Locale locale) {
            this.duration = duration;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParseableDurationForLocale that = (ParseableDurationForLocale)o;
            if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
                return false;
            }
            return this.locale != null ? this.locale.equals(that.locale) : that.locale == null;
        }

        public int hashCode() {
            int result = this.duration != null ? this.duration.hashCode() : 0;
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            return result;
        }
    }
}

