/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Preconditions;
import org.joda.time.DateTimeUtils;

public class ThreadLocalMillisProvider
implements DateTimeUtils.MillisProvider {
    private static final DateTimeUtils.MillisProvider systemMillisProvider = new DateTimeUtils.MillisProvider(){

        public long getMillis() {
            return System.currentTimeMillis();
        }
    };
    private static final ThreadLocal<DateTimeUtils.MillisProvider> local = new ThreadLocal<DateTimeUtils.MillisProvider>(){

        @Override
        protected DateTimeUtils.MillisProvider initialValue() {
            return systemMillisProvider;
        }
    };
    private static final DateTimeUtils.MillisProvider INSTANCE = new ThreadLocalMillisProvider();

    public static final void setCurrentMillisSystem() throws SecurityException {
        ThreadLocalMillisProvider.install();
        local.set(systemMillisProvider);
    }

    public static final void setCurrentMillisFixed(long fixedMillis) throws SecurityException {
        ThreadLocalMillisProvider.install();
        local.set(new FixedMillisProvider(fixedMillis));
    }

    public static final void setCurrentMillisOffset(long offsetMillis) throws SecurityException {
        ThreadLocalMillisProvider.install();
        local.set(new OffsetMillisProvider(offsetMillis));
    }

    public static final void setCurrentMillisProvider(DateTimeUtils.MillisProvider millisProvider) throws SecurityException {
        ThreadLocalMillisProvider.install();
        local.set((DateTimeUtils.MillisProvider)Preconditions.checkNotNull((Object)millisProvider));
    }

    public static void clear() {
        local.remove();
    }

    public static DateTimeUtils.MillisProvider current() {
        return local.get();
    }

    private static void install() {
        DateTimeUtils.setCurrentMillisProvider((DateTimeUtils.MillisProvider)INSTANCE);
    }

    private ThreadLocalMillisProvider() {
    }

    public long getMillis() {
        return local.get().getMillis();
    }

    public static class FixedMillisProvider
    implements DateTimeUtils.MillisProvider {
        private final long iMillis;

        public FixedMillisProvider(long fixedMillis) {
            this.iMillis = fixedMillis;
        }

        public long getMillis() {
            return this.iMillis;
        }
    }

    public static class OffsetMillisProvider
    implements DateTimeUtils.MillisProvider {
        private final long iMillis;

        public OffsetMillisProvider(long offsetMillis) {
            this.iMillis = offsetMillis;
        }

        public long getMillis() {
            return System.currentTimeMillis() + this.iMillis;
        }
    }
}

