/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;

public class Types {
    public static ParameterizedType newParameterizedType(final Class<?> rawType, final Type ... arguments) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return arguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return rawType.getEnclosingClass();
            }
        };
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
            throw new IllegalStateException(String.format("getRawType of the parameterized type %s did not return a class, but %s", type, rawType));
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Types.getRawType(componentType), 0).getClass();
        }
        throw new IllegalArgumentException(String.format("Unhandled type %s, unable to extract its raw type.", type));
    }

    public static boolean isAssignableFrom(Type t1, Type t2) {
        Preconditions.checkNotNull((Object)t1);
        Preconditions.checkNotNull((Object)t2);
        if (t1.equals(t2)) {
            return true;
        }
        if (t1 instanceof Class) {
            return ((Class)t1).isAssignableFrom(Types.getRawType(t2));
        }
        if (t1 instanceof ParameterizedType) {
            Class<?> rawTypeT2;
            Class<?> rawTypeT1 = Types.getRawType(t1);
            if (!rawTypeT1.isAssignableFrom(rawTypeT2 = Types.getRawType(t2)) || rawTypeT1.equals(rawTypeT2)) {
                return false;
            }
            if (t2 instanceof Class) {
                Type[] genericInterfaces;
                Type genericSuperclass = ((Class)t2).getGenericSuperclass();
                if (genericSuperclass != null && Types.isAssignableFrom(t1, genericSuperclass)) {
                    return true;
                }
                for (Type genericInterface : genericInterfaces = ((Class)t2).getGenericInterfaces()) {
                    if (!Types.isAssignableFrom(t1, genericInterface)) continue;
                    return true;
                }
                return false;
            }
            if (t2 instanceof ParameterizedType) {
                Type[] genericInterfaces;
                Type[] actualTypeArguments = ((ParameterizedType)t2).getActualTypeArguments();
                TypeVariable<Class<?>>[] typeParameters = rawTypeT2.getTypeParameters();
                HashMap typesMap = Maps.newHashMapWithExpectedSize((int)typeParameters.length);
                for (int i = 0; i < typeParameters.length; ++i) {
                    typesMap.put(typeParameters[i], actualTypeArguments[i]);
                }
                Type genericSuperclass = rawTypeT2.getGenericSuperclass();
                if (genericSuperclass != null) {
                    if (genericSuperclass instanceof Class) {
                        if (Types.isAssignableFrom(t1, genericSuperclass)) {
                            return true;
                        }
                    } else if (genericSuperclass instanceof ParameterizedType) {
                        ParameterizedType genericSuperclassParameterized = (ParameterizedType)genericSuperclass;
                        Type[] genericSuperclassActualTypeArguments = genericSuperclassParameterized.getActualTypeArguments();
                        for (int i = 0; i < genericSuperclassActualTypeArguments.length; ++i) {
                            if (!(genericSuperclassActualTypeArguments[i] instanceof TypeVariable)) continue;
                            genericSuperclassActualTypeArguments[i] = (Type)typesMap.get(genericSuperclassActualTypeArguments[i]);
                        }
                        Type genericSuperclassRawType = genericSuperclassParameterized.getRawType();
                        if (Types.isAssignableFrom(t1, Types.newParameterizedType((Class)genericSuperclassRawType, genericSuperclassActualTypeArguments))) {
                            return true;
                        }
                    }
                }
                for (Type genericInterface : genericInterfaces = rawTypeT2.getGenericInterfaces()) {
                    if (genericInterface instanceof Class) {
                        if (!Types.isAssignableFrom(t1, genericInterface)) continue;
                        return true;
                    }
                    if (!(genericInterface instanceof ParameterizedType)) continue;
                    ParameterizedType genericInterfaceParameterized = (ParameterizedType)genericInterface;
                    Type[] genericInterfaceActualTypeArguments = genericInterfaceParameterized.getActualTypeArguments();
                    for (int i = 0; i < genericInterfaceActualTypeArguments.length; ++i) {
                        if (!(genericInterfaceActualTypeArguments[i] instanceof TypeVariable)) continue;
                        genericInterfaceActualTypeArguments[i] = (Type)typesMap.get(genericInterfaceActualTypeArguments[i]);
                    }
                    Type genericInterfaceRawType = genericInterfaceParameterized.getRawType();
                    if (!Types.isAssignableFrom(t1, Types.newParameterizedType((Class)genericInterfaceRawType, genericInterfaceActualTypeArguments))) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

