/*
 * Decompiled with CFR 0.152.
 */
package restx.common.watch;

import com.google.common.eventbus.EventBus;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import restx.common.watch.EventCoalescor;
import restx.common.watch.FileWatchEvent;

public class FileWatchEventCoalescor
extends EventCoalescor<FileWatchEvent> {
    private final HashMap<FileWatchEventKey, Deque<EventReference>> queue = new HashMap();

    public static FileWatchEventCoalescor create(EventBus eventBus, long coalescePeriod) {
        return new FileWatchEventCoalescor(eventBus, coalescePeriod);
    }

    FileWatchEventCoalescor(EventBus eventBus, long coalescePeriod) {
        super(eventBus, coalescePeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(FileWatchEvent event) {
        HashMap<FileWatchEventKey, Deque<EventReference>> hashMap = this.queue;
        synchronized (hashMap) {
            FileWatchEventKey key = FileWatchEventKey.fromEvent(event);
            Deque<EventReference> fileEvents = this.queue.get(key);
            if (fileEvents == null) {
                fileEvents = new ArrayDeque<EventReference>();
                this.queue.put(key, fileEvents);
                EventReference reference = EventReference.of(key, event);
                fileEvents.add(reference);
                this.schedulePost(reference);
                return;
            }
            EventReference last = fileEvents.getLast();
            if (!this.merge(last, event)) {
                EventReference reference = EventReference.of(key, event);
                fileEvents.add(reference);
                this.schedulePost(reference);
            }
        }
    }

    private boolean merge(EventReference previous, FileWatchEvent current) {
        if (!previous.isPresent()) {
            return false;
        }
        if (previous.getReference().getKind() == current.getKind()) {
            return true;
        }
        if (previous.getReference().getKind() == StandardWatchEventKinds.ENTRY_DELETE && current.getKind() == StandardWatchEventKinds.ENTRY_CREATE) {
            previous.updateReference(FileWatchEvent.fromWithKind(previous.getReference(), StandardWatchEventKinds.ENTRY_MODIFY));
            return true;
        }
        if (previous.getReference().getKind() == StandardWatchEventKinds.ENTRY_CREATE && current.getKind() == StandardWatchEventKinds.ENTRY_MODIFY) {
            return true;
        }
        if (previous.getReference().getKind() == StandardWatchEventKinds.ENTRY_CREATE && current.getKind() == StandardWatchEventKinds.ENTRY_DELETE) {
            previous.clearReference();
            return true;
        }
        return false;
    }

    void schedulePost(final EventReference event) {
        this.executor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap<FileWatchEventKey, Deque<EventReference>> hashMap = FileWatchEventCoalescor.this.queue;
                synchronized (hashMap) {
                    try {
                        if (event.isPresent()) {
                            FileWatchEventCoalescor.this.eventBus.post((Object)event.getReference());
                        }
                    }
                    finally {
                        FileWatchEventCoalescor.this.dequeue(event.getKey(), event);
                    }
                }
            }
        }, this.coalescePeriod, TimeUnit.MILLISECONDS);
    }

    void dequeue(FileWatchEventKey key, EventReference event) {
        Deque<EventReference> fileEvents = this.queue.get(key);
        if (fileEvents != null && fileEvents.remove(event) && fileEvents.isEmpty()) {
            this.queue.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        HashMap<FileWatchEventKey, Deque<EventReference>> hashMap = this.queue;
        synchronized (hashMap) {
            this.queue.clear();
        }
    }

    static class FileWatchEventKey {
        private final Path dir;
        private final Path path;

        static FileWatchEventKey fromEvent(FileWatchEvent event) {
            return new FileWatchEventKey(event.getDir(), event.getPath());
        }

        private FileWatchEventKey(Path dir, Path path) {
            this.dir = dir;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileWatchEventKey)) {
                return false;
            }
            FileWatchEventKey that = (FileWatchEventKey)o;
            return this.dir.equals(that.dir) && this.path.equals(that.path);
        }

        public int hashCode() {
            int result = this.dir.hashCode();
            result = 31 * result + this.path.hashCode();
            return result;
        }
    }

    static class EventReference {
        private final FileWatchEventKey key;
        private FileWatchEvent reference;

        static EventReference of(FileWatchEventKey key, FileWatchEvent reference) {
            return new EventReference(key, reference);
        }

        private EventReference(FileWatchEventKey key, FileWatchEvent reference) {
            this.key = key;
            this.reference = reference;
        }

        public void updateReference(FileWatchEvent newEvent) {
            this.reference = newEvent;
        }

        public void clearReference() {
            this.reference = null;
        }

        public boolean isPresent() {
            return this.reference != null;
        }

        public FileWatchEventKey getKey() {
            return this.key;
        }

        public FileWatchEvent getReference() {
            return this.reference;
        }
    }
}

