/*
 * Decompiled with CFR 0.152.
 */
package restx.common.watch;

import com.google.common.eventbus.EventBus;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import restx.common.watch.EventCoalescor;
import restx.common.watch.FileWatchEvent;
import restx.common.watch.FileWatchEventCoalescor;
import restx.common.watch.WatcherService;
import restx.common.watch.WatcherSettings;

public class StdWatcherService
implements WatcherService {
    @Override
    public Closeable watch(EventBus eventBus, ExecutorService executor, Path dir, WatcherSettings settings) {
        try {
            final WatchDir watchDir = new WatchDir(eventBus, dir, settings);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    watchDir.processEvents();
                }
            });
            return watchDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static class WatchDir
    implements Closeable {
        private final WatchService watcher = FileSystems.getDefault().newWatchService();
        private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
        private final boolean recursive;
        private final EventCoalescor<FileWatchEvent> coalescor;
        private final Path root;
        private boolean trace = false;

        static <T> WatchEvent<T> cast(WatchEvent<?> event) {
            return event;
        }

        private void register(Path dir) throws IOException {
            WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            if (this.trace) {
                Path prev = this.keys.get(key);
                if (prev == null) {
                    System.out.format("register: %s\n", dir);
                } else if (!dir.equals(prev)) {
                    System.out.format("update: %s -> %s\n", prev, dir);
                }
            }
            this.keys.put(key, dir);
        }

        private void registerAll(Path start) throws IOException {
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.register(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        WatchDir(EventBus eventBus, Path dir, WatcherSettings settings) throws IOException {
            this.recursive = settings.recurse();
            this.root = dir;
            this.coalescor = FileWatchEventCoalescor.create(eventBus, settings.coalescePeriod());
            if (this.recursive) {
                this.registerAll(dir);
            } else {
                this.register(dir);
            }
        }

        void processEvents() {
            try {
                while (true) {
                    WatchKey key;
                    try {
                        key = this.watcher.take();
                    }
                    catch (InterruptedException x) {
                        return;
                    }
                    Path dir = this.keys.get(key);
                    if (dir == null) {
                        System.err.println("WatchKey not recognized!!");
                        continue;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent ev = WatchDir.cast(event);
                        this.coalescor.post(FileWatchEvent.newInstance(this.root, dir, (Path)ev.context(), ev.kind(), ev.count()));
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        Path name = (Path)ev.context();
                        Path child = dir.resolve(name);
                        if (!this.recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                        try {
                            if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                            this.registerAll(child);
                        }
                        catch (IOException iOException) {}
                    }
                    boolean valid = key.reset();
                    if (valid) continue;
                    this.keys.remove(key);
                    if (this.keys.isEmpty()) break;
                }
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.watcher.close();
            this.coalescor.close();
        }
    }
}

