/*
 * Decompiled with CFR 0.152.
 */
package restx.common.watch;

import java.util.ServiceLoader;
import restx.common.OSUtils;
import restx.common.watch.StdWatcherService;
import restx.common.watch.WatcherService;

public class WatcherServiceLoader {
    private static final WatcherService WATCHER_SERVICE;

    public static WatcherService getWatcherService() {
        return WATCHER_SERVICE;
    }

    static {
        WatcherService watcher = null;
        ServiceLoader<WatcherService> watcherServices = ServiceLoader.load(WatcherService.class);
        for (WatcherService watcherService : watcherServices) {
            if (!watcherService.isEnabled()) continue;
            watcher = watcherService;
            break;
        }
        if (watcher == null) {
            watcher = new StdWatcherService();
            if (OSUtils.isMacOSX()) {
                System.out.println("WARN: using default watch service on MacOSX uses polling.\nAdd `restx-barbarywatch` to your classpath to have real time file system notifications.");
            }
        }
        WATCHER_SERVICE = watcher;
    }
}

