/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.AppSettings;
import restx.classloader.CompilationFinishedEvent;
import restx.classloader.CompilationManager;
import restx.classloader.CompilationSettings;
import restx.common.MoreFiles;

public class Apps {
    private static final Logger logger = LoggerFactory.getLogger(Apps.class);
    private static final String PATH_SEP = StandardSystemProperty.PATH_SEPARATOR.value();
    private final AppSettings settings;

    public static Apps with(AppSettings appSettings) {
        return new Apps(appSettings);
    }

    public Apps(AppSettings settings) {
        this.settings = settings;
    }

    public CompilationManager newAppCompilationManager(EventBus eventBus, CompilationSettings compilationSettings) {
        if (!Apps.hasSystemJavaCompiler()) {
            throw new IllegalStateException("trying to setup a compilation manager while no system compiler is available. This should be prevented by checking the system java compiler first. Use hasSystemJavaCompiler() to check that before calling this method.");
        }
        if (Apps.hasJavadocTools()) {
            try {
                final Class<?> apiDocsRunnerClass = Class.forName("restx.apidocs.doclet.ApidocsDocletRunner");
                eventBus.register(new Object(){

                    @Subscribe
                    public void onCompilationFinished(CompilationFinishedEvent event) {
                        try {
                            Object apiDocsInstance = apiDocsRunnerClass.newInstance();
                            apiDocsRunnerClass.getMethod("setTargetDir", Path.class).invoke(apiDocsInstance, Apps.this.getTargetClasses());
                            apiDocsRunnerClass.getMethod("addSources", Path.class).invoke(apiDocsInstance, event.getSources());
                            apiDocsRunnerClass.getMethod("run", new Class[0]).invoke(apiDocsInstance, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            logger.info("Failed to initialize and call restx.apidocs.doclet.ApidocsDocletRunner ", (Throwable)e);
                        }
                    }
                });
            }
            catch (ClassNotFoundException e) {
                logger.info("can't enable Apidocs doclet: restx-api-doclet is your classpath");
            }
        } else {
            logger.info("can't enable Apidocs doclet: make sure tools.jar is in your classpath");
        }
        return new CompilationManager(eventBus, this.getSourceRoots(), this.getTargetClasses(), compilationSettings);
    }

    public Path getTargetClasses() {
        return FileSystems.getDefault().getPath(this.settings.targetClasses(), new String[0]);
    }

    public Iterable<Path> getSourceRoots() {
        return Iterables.transform((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)this.settings.sourceRoots()), (Function)MoreFiles.strToPath);
    }

    public boolean sourcesAvailableIn(Path basePath) {
        for (Path sourceRoot : this.getSourceRoots()) {
            if (!Files.notExists(basePath.resolve(sourceRoot), new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    public Optional<String> guessAppBasePackage(Path fromDir) {
        for (Path sourceRoot : this.getSourceRoots()) {
            Path sourceRootDir = fromDir.resolve(sourceRoot);
            try {
                final Path[] appServer = new Path[1];
                Files.walkFileTree(sourceRootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().equals("AppServer.java")) {
                            appServer[0] = file;
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (appServer[0] == null) continue;
                return Optional.of((Object)sourceRootDir.relativize(appServer[0]).getParent().toString().replace("/", "."));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.absent();
    }

    public Process run(File workingDirectory, Path targetClasses, Path dependenciesDir, List<String> vmOptions, String mainClassName, List<String> args, boolean quiet) throws IOException {
        String classpath = targetClasses.toString() + PATH_SEP + dependenciesDir.toString() + "/*";
        File toolsJar = new File(System.getenv("JAVA_HOME") + "/lib/tools.jar");
        if (toolsJar.exists()) {
            classpath = classpath + PATH_SEP + toolsJar.getAbsolutePath();
        }
        final Process process = new ProcessBuilder((List<String>)ImmutableList.builder().add((Object[])new String[]{"java", "-cp", classpath}).addAll(vmOptions).add((Object)mainClassName).addAll(args).build()).redirectErrorStream(true).redirectOutput(quiet ? ProcessBuilder.Redirect.PIPE : ProcessBuilder.Redirect.INHERIT).directory(workingDirectory.getAbsoluteFile()).start();
        if (quiet) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ByteStreams.copy((InputStream)process.getInputStream(), (OutputStream)ByteStreams.nullOutputStream());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }).start();
        }
        return process;
    }

    public static boolean hasJavadocTools() {
        try {
            Class.forName("com.sun.tools.javadoc.Main");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasSystemJavaCompiler() {
        try {
            Class<?> tp = Class.forName("javax.tools.ToolProvider");
            return tp.getMethod("getSystemJavaCompiler", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

