/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.Collection;
import restx.HttpSettings;
import restx.common.RestxConfig;
import restx.factory.Component;

@Component(priority=1000)
public class HttpSettingsConfig
implements HttpSettings {
    private final RestxConfig config;

    public HttpSettingsConfig(RestxConfig config) {
        this.config = config;
    }

    @Override
    public Collection<String> forwardedSupport() {
        return Splitter.on((String)",").trimResults().splitToList((CharSequence)this.config.getString("restx.http.XForwardedSupport").or((Object)"127.0.0.1"));
    }

    @Override
    public Optional<String> host() {
        return this.config.getString("restx.http.host");
    }

    @Override
    public Optional<String> scheme() {
        return this.config.getString("restx.http.scheme");
    }

    @Override
    public Collection<String> gzipPaths() {
        return Splitter.on((String)",").trimResults().splitToList((CharSequence)this.config.getString("restx.http.gzip.paths").or((Object)"/{s:.+}"));
    }

    @Override
    public boolean decodeURLPathParams() {
        return (Boolean)this.config.getBoolean("restx.http.decode.url.path.params").or((Object)Boolean.TRUE);
    }
}

