/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.StdRestxRequestMatch;
import restx.factory.Component;

@Component(priority=10000)
public class ResponseCloserFilter
implements RestxRouteFilter,
RestxHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCloserFilter.class);

    @Override
    public Optional<RestxHandlerMatch> match(RestxRoute route) {
        return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("/*"), this));
    }

    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        ctx.nextHandlerMatch().handle(req, resp, ctx);
        try {
            resp.close();
        }
        catch (Exception e) {
            logger.error("ERROR while closing response: " + e.getMessage(), (Throwable)e);
        }
    }
}

