/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.AppSettings;
import restx.Apps;
import restx.RestxMainRouter;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.RestxRouting;
import restx.StdRestxMainRouter;
import restx.classloader.ColdClasses;
import restx.classloader.CompilationFinishedEvent;
import restx.classloader.CompilationManager;
import restx.classloader.CompilationSettings;
import restx.classloader.HotReloadingClassLoader;
import restx.common.MoreClasses;
import restx.common.MoreStrings;
import restx.common.RestxConfig;
import restx.common.metrics.api.MetricRegistry;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SingletonFactoryMachine;
import restx.factory.StdWarehouse;
import restx.factory.Warehouse;
import restx.http.HttpStatus;
import restx.security.RestxSessionCookieFilter;
import restx.server.WebServer;
import restx.server.WebServers;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecRecorder;
import restx.specs.RestxSpecTape;

public class RestxMainRouterFactory {
    private static final Logger logger = LoggerFactory.getLogger(RestxMainRouterFactory.class);
    private static final Map<String, RestxMainRouter> routers = new HashMap<String, RestxMainRouter>();
    private final AppSettings appSettings;

    public static synchronized RestxMainRouter newInstance(String serverId, Optional<String> baseUri) {
        Preconditions.checkNotNull((Object)serverId);
        RestxMainRouter router = routers.get(serverId);
        if (router == null) {
            AppSettings settings = (AppSettings)RestxMainRouterFactory.loadFactory(RestxMainRouterFactory.newFactoryBuilder(serverId)).getComponent(AppSettings.class);
            router = new RestxMainRouterFactory(settings).build(serverId, baseUri);
        }
        return router;
    }

    public static synchronized Optional<RestxMainRouter> getInstance(String serverId) {
        return Optional.fromNullable((Object)routers.get(serverId));
    }

    public static synchronized void clear(String serverId) {
        routers.remove(serverId);
        Optional factory = Factory.getFactory((String)serverId);
        if (factory.isPresent()) {
            ((Factory)factory.get()).close();
            Factory.unregister((String)serverId, (Factory)((Factory)factory.get()));
        }
    }

    private RestxMainRouterFactory(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestxMainRouter build(String serverId, Optional<String> baseUri) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull(baseUri);
        logger.info("LOADING MAIN ROUTER");
        if ("dev".equals(this.getMode()) && !this.useHotCompile()) {
            logger.info("\nHot compile is not enabled, no on the fly compilation will be performed\nTo enable it, use '-Drestx.app.package=<rootAppPackage> -Drestx.router.hotcompile=true' as VM argument\nand make sure you have JDK tools.jar in your classpath");
            if (!this.useHotReload()) {
                logger.info("\nHot reload is not enabled either, no hot reload on recompilation will be performed\nTo enable it, use '-Drestx.app.package=<rootAppPackage> -Drestx.router.hotreload=true' as VM argument");
            }
        }
        if (this.getLoadFactoryMode().equals("onstartup")) {
            if ("recording".equals(this.getMode())) {
                throw new IllegalStateException("can't use RECORDING mode without per request factory loading");
            }
            Factory factory = RestxMainRouterFactory.loadFactory(RestxMainRouterFactory.newFactoryBuilder(serverId));
            factory = Factory.register((String)serverId, (Factory)factory);
            StdRestxMainRouter mainRouter = this.newStdRouter(factory);
            routers.put(serverId, mainRouter);
            factory.start().and().prepare();
            this.logPrompt(baseUri, "READY", mainRouter);
            return mainRouter;
        }
        if (this.getLoadFactoryMode().equals("onrequest") || this.getLoadFactoryMode().equals("cleanrequest")) {
            Factory factory;
            this.logPrompt(baseUri, ">> LOAD ON REQUEST <<" + (this.getLoadFactoryMode().equals("cleanrequest") ? " >> CLEAN <<" : ""), null);
            ClassLoader mainFactoryClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader previous = Thread.currentThread().getContextClassLoader();
            if (this.useAutoCompile()) {
                CompilationManager compilationManager = Apps.with(this.appSettings).newAppCompilationManager(new EventBus(), CompilationManager.DEFAULT_SETTINGS);
                compilationManager.incrementalCompile();
                HotReloadingClassLoader hotReloadingClassLoader = compilationManager.newHotReloadingClassLoader((String)this.appSettings.appPackage().get(), ImmutableSet.of());
                mainFactoryClassLoader = hotReloadingClassLoader;
                Thread.currentThread().setContextClassLoader((ClassLoader)hotReloadingClassLoader);
            }
            try {
                factory = RestxMainRouterFactory.loadFactory(RestxMainRouterFactory.newFactoryBuilder(serverId));
                factory = Factory.register((String)serverId, (Factory)factory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previous);
            }
            StdWarehouse warehouse = this.getLoadFactoryMode().equals("cleanrequest") ? new StdWarehouse() : factory.getWarehouse();
            RestxMainRouter router = new PerRequestFactoryLoader(serverId, (Warehouse)warehouse);
            Factory settingsFactory = RestxMainRouterFactory.loadFactory(RestxMainRouterFactory.newFactoryBuilder(serverId));
            router = new RecordingMainRouter(serverId, router, (RestxSpec.StorageSettings)settingsFactory.getComponent(RestxSpec.StorageSettings.class));
            if (this.useHotCompile()) {
                final RestxConfig config = (RestxConfig)settingsFactory.getComponent(RestxConfig.class);
                router = new CompilationManagerRouter(router, (EventBus)factory.getComponent(EventBus.class), RestxMainRouterFactory.getColdClasses(mainFactoryClassLoader, factory, this.appSettings), new CompilationSettings(){

                    public int autoCompileCoalescePeriod() {
                        return (Integer)config.getInt("restx.fs.watch.coalesce.period").get();
                    }

                    public Predicate<Path> classpathResourceFilter() {
                        return CompilationManager.DEFAULT_CLASSPATH_RESOURCE_FILTER;
                    }
                });
            } else if (this.useHotReload()) {
                router = new HotReloadRouter(router, RestxMainRouterFactory.getColdClasses(mainFactoryClassLoader, factory, this.appSettings));
            }
            routers.put(serverId, router);
            if (this.getLoadFactoryMode().equals("onrequest")) {
                factory.start();
            }
            return router;
        }
        throw new IllegalStateException("illegal load factory mode: '" + this.getLoadFactoryMode() + "'. It must be either 'onstartup', 'onrequest' or 'cleanrequest'.");
    }

    private void logPrompt(Optional<String> baseUri, String state, StdRestxMainRouter mainRouter) {
        logger.info("\n--------------------------------------\n -- RESTX " + state + " >> " + this.getMode().toUpperCase(Locale.ENGLISH) + " MODE <<" + this.getHotIndicator() + "\n" + (String)(mainRouter != null ? " -- " + mainRouter.getNbFilters() + " filters\n" : "") + (String)(mainRouter != null ? " -- " + mainRouter.getNbRoutes() + " routes\n" : "") + (String)(((String)baseUri.or((Object)"")).isEmpty() ? "" : " -- for admin console,\n --   VISIT " + (String)baseUri.get() + "/@/ui/\n") + " --\n");
    }

    private String getHotIndicator() {
        if (this.useAutoCompile()) {
            return " >> AUTO COMPILE <<";
        }
        if (this.useHotCompile()) {
            return " >> HOT COMPILE <<";
        }
        if (this.useHotReload()) {
            return " >> HOT RELOAD <<";
        }
        return "";
    }

    private static Factory loadFactory(Factory.Builder builder) {
        Factory factory = builder.build();
        logger.debug("restx factory ready: {}", factory.dumper());
        return factory;
    }

    private static Factory.Builder newFactoryBuilder(String serverId, Optional<String> bladeId, Optional<String> threadLocalId, String mode) {
        Factory.Builder builder = RestxMainRouterFactory.newFactoryBuilder(serverId);
        if (threadLocalId.isPresent()) {
            builder.addLocalMachines(Factory.LocalMachines.threadLocalFrom((String)((String)threadLocalId.get())));
        }
        if (bladeId.isPresent()) {
            builder.addLocalMachines(Factory.LocalMachines.contextLocal((String)Blade.contextId(serverId, (String)bladeId.get())));
        }
        builder.addMachine((FactoryMachine)new SingletonFactoryMachine(-100000, NamedComponent.of(String.class, (String)"restx.mode", (Object)mode)));
        return builder;
    }

    private static Factory.Builder newFactoryBuilder(String serverId) {
        Factory.Builder builder = RestxMainRouterFactory.newFactoryBuilder();
        if (serverId != null) {
            builder.addLocalMachines(Factory.LocalMachines.contextLocal((String)serverId));
            Optional<WebServer> serverById = WebServers.getServerById(serverId);
            builder.addMachine((FactoryMachine)new SingletonFactoryMachine(0, NamedComponent.of(String.class, (String)"restx.server.id", (Object)serverId))).addMachine((FactoryMachine)new SingletonFactoryMachine(0, NamedComponent.of(String.class, (String)"restx.server.baseUrl", (Object)(serverById.isPresent() ? ((WebServer)serverById.get()).baseUrl() : "")))).addMachine((FactoryMachine)new SingletonFactoryMachine(0, NamedComponent.of(String.class, (String)"restx.server.port", (Object)(serverById.isPresent() ? String.valueOf(((WebServer)serverById.get()).getPort()) : "")))).addMachine((FactoryMachine)new SingletonFactoryMachine(0, NamedComponent.of(String.class, (String)"restx.server.type", (Object)(serverById.isPresent() ? ((WebServer)serverById.get()).getServerType() : ""))));
        }
        return builder;
    }

    private static Factory.Builder newFactoryBuilder() {
        return Factory.builder().addFromServiceLoader().addLocalMachines(Factory.LocalMachines.threadLocal());
    }

    private StdRestxMainRouter newStdRouter(Factory factory) {
        return new StdRestxMainRouter((MetricRegistry)factory.getComponent(MetricRegistry.class), (RestxRouting)factory.getComponent(RestxRouting.class), (String)factory.getComponent(Name.of(String.class, (String)"restx.mode")));
    }

    private String getLoadFactoryMode() {
        if (this.appSettings.factoryLoadMode().isPresent()) {
            return (String)this.appSettings.factoryLoadMode().get();
        }
        if ("test".equals(this.getMode()) || "infinirest".equals(this.getMode())) {
            return "cleanrequest";
        }
        if ("recording".equals(this.getMode()) || this.useHotCompile() || this.useHotReload()) {
            return "onrequest";
        }
        return "onstartup";
    }

    private boolean useHotReload() {
        if (((Boolean)this.appSettings.hotReload().or((Object)Boolean.FALSE)).booleanValue()) {
            if (!this.appSettings.appPackage().isPresent()) {
                logger.info("can't enable hot reload: restx.app.package is not set.\nRun your app with -Drestx.app.package=<app.base.package> to enable hot reload.");
                return false;
            }
            return true;
        }
        return (Boolean)this.appSettings.hotReload().or((Object)Boolean.TRUE) != false && !this.getMode().equals("prod") && !this.getMode().equals("test") && this.appSettings.appPackage().isPresent();
    }

    private boolean useHotCompile() {
        if (((Boolean)this.appSettings.hotCompile().or((Object)Boolean.FALSE)).booleanValue() || ((Boolean)this.appSettings.autoCompile().or((Object)Boolean.FALSE)).booleanValue()) {
            if (!this.appSettings.appPackage().isPresent()) {
                logger.info("can't enable hot compile: restx.app.package is not set.\nRun your app with -Drestx.app.package=<app.base.package> to enable hot compile.");
                return false;
            }
            if (!this.hasSystemJavaCompiler()) {
                logger.info("can't enable hot compile: tools.jar is not in classpath.\nRun your app with a JDK rather than a JRE to enable hot compile.");
                return false;
            }
            return true;
        }
        return (Boolean)this.appSettings.hotCompile().or((Object)Boolean.TRUE) != false && !this.getMode().equals("prod") && !this.getMode().equals("test") && this.appSettings.appPackage().isPresent() && this.hasSystemJavaCompiler();
    }

    private String getMode() {
        return this.appSettings.mode();
    }

    private String getMode(RestxRequest restxRequest) {
        return (String)restxRequest.getHeader("RestxMode").or((Object)this.getMode());
    }

    private boolean hasSystemJavaCompiler() {
        return Apps.hasSystemJavaCompiler();
    }

    private boolean useAutoCompile() {
        return (Boolean)this.appSettings.autoCompile().or((Object)Boolean.TRUE) != false && this.useHotCompile();
    }

    private static void handleUnsatisfiedDependencyOnHotReload(RestxResponse restxResponse, Factory.UnsatisfiedDependenciesException ex, String hotPackage) throws IOException {
        restxResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        PrintWriter writer = restxResponse.getWriter();
        boolean hotColdFound = false;
        for (Factory.UnsatisfiedDependency unsatisfiedDependency : ex.getUnsatisfiedDependencies().getUnsatisfiedDependencies()) {
            if (unsatisfiedDependency.getPath().isEmpty()) continue;
            Class dependerClass = ((Factory.SatisfiedQuery)Iterables.getLast((Iterable)unsatisfiedDependency.getPath())).getName().getClazz();
            Class dependeeClass = unsatisfiedDependency.getUnsatisfied().getComponentClass();
            if (dependerClass.getName().startsWith(hotPackage) || !dependeeClass.getName().startsWith(hotPackage)) continue;
            String msg = String.format(">>>>>> SOURCE CODE ERROR >>>>>>>>>>>>>>>>>>>>>>>>>>>>\nYou are currently using hot reload feature of RESTX which has some limitations.\n\nYou can't inject a component which is hot reloaded (called a 'Hot' component)\n  into a component which is not hot reloaded (called a 'Cold' component)\n\nSuch a dependency from a 'Cold' class to a 'Hot' class has been found in your sources:\n\n     `%s`\n          ^------------------------------------- HOT because it is in package `%s`\n\n                       is injected into\n\n     `%s`\n          ^------------------------------------- COLD because it is NOT in package `%s`\n\n\n                >>> THIS IS NOT SUPPORTED, IT CAUSES CLASSLOADING ERRORS <<<\n\n\nPossible solutions:\n===================\n\n1) remove that dependency\n      Check the source of `%s`\n      and remove its dependency on `%s`\n\n2) change which classes are hot reloaded\n      Classes which are hot reloaded are in package `%s`.\n      You can change that by setting the `restx.app.package` system property.\n\n3) don't use hot compile mode\n      Use production mode\n      or explicitly disable it by setting `restx.router.hotcompile`\n                                 and / or `restx.router.hotreload` to false\n\n>>>>>> SOURCE CODE ERROR >>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n", dependeeClass.getName(), hotPackage, dependerClass.getName(), hotPackage, dependerClass.getName(), dependeeClass.getName(), hotPackage);
            logger.error("\n\n" + msg);
            writer.println(msg);
            hotColdFound = true;
            break;
        }
        if (!hotColdFound) {
            String msg = "Error when loading Factory to process your request.\nOne or more dependency injections can be satisfied.\n\n" + MoreStrings.indent((String)ex.getMessage(), (int)2);
            logger.error(msg);
            writer.println(msg);
        }
    }

    private static Supplier<ImmutableSet<Class>> getColdClasses(final ClassLoader mainFactoryClassLoader, final Factory factory, final AppSettings appSettings) {
        return new Supplier<ImmutableSet<Class>>(){

            public ImmutableSet<Class> get() {
                HashSet coldClasses = new HashSet();
                for (Name name : factory.getWarehouse().listNames()) {
                    Optional c = factory.queryByName(name).findOneAsComponent();
                    if (c.isPresent()) {
                        coldClasses.add(c.get().getClass());
                        coldClasses.addAll(MoreClasses.getInheritedClasses(c.get().getClass()));
                        continue;
                    }
                    logger.debug("invalid cold class {}: found in factory warehouse but not available as component. Ignored.", (Object)name);
                }
                coldClasses.addAll((Collection)appSettings.coldClasses().transform(new Function<String, ImmutableSet<Class<?>>>(){

                    public ImmutableSet<Class<?>> apply(String input) {
                        return ColdClasses.extractFromString((ClassLoader)mainFactoryClassLoader, (String)input);
                    }
                }).or((Object)ImmutableSet.of()));
                try {
                    coldClasses.addAll((Collection<Class<?>>)ColdClasses.extractFromResources((ClassLoader)mainFactoryClassLoader));
                }
                catch (IOException e) {
                    logger.warn("Unable to extract cold classes from resources, due to {}", (Object)e.getMessage());
                }
                logger.debug("cold classes: {}", coldClasses);
                return ImmutableSet.copyOf(coldClasses);
            }
        };
    }

    private class PerRequestFactoryLoader
    implements RestxMainRouter {
        private final String serverId;
        private final Warehouse warehouse;

        public PerRequestFactoryLoader(String serverId, Warehouse warehouse) {
            this.serverId = serverId;
            this.warehouse = warehouse;
        }

        @Override
        public void route(RestxRequest restxRequest, RestxResponse restxResponse) throws IOException {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Factory factory = RestxMainRouterFactory.loadFactory(RestxMainRouterFactory.newFactoryBuilder(this.serverId, restxRequest.getHeader("RestxBlade"), restxRequest.getHeader("RestxThreadLocal"), RestxMainRouterFactory.this.getMode(restxRequest)).addWarehouseProvider(this.warehouse));
            if ("cleanrequest".equals(RestxMainRouterFactory.this.getLoadFactoryMode())) {
                try {
                    factory.start();
                }
                catch (Exception ex) {
                    logger.error("Exception when using factory to start components on clean request: " + ex.getMessage(), (Throwable)ex);
                    Throwables.propagate((Throwable)ex);
                }
            }
            factory.prepare();
            try {
                StdRestxMainRouter stdRestxMainRouter = RestxMainRouterFactory.this.newStdRouter(factory);
                if (stopwatch.elapsed(TimeUnit.MILLISECONDS) > 200L) {
                    logger.info("{} - per request factory created in {}", (Object)restxRequest, (Object)stopwatch);
                } else {
                    logger.debug("{} - per request factory created in {}", (Object)restxRequest, (Object)stopwatch);
                }
                stdRestxMainRouter.route(restxRequest, restxResponse);
            }
            catch (Factory.UnsatisfiedDependenciesException ex) {
                if (restxRequest.getHeader("RestxDebug").isPresent()) {
                    logger.error("{} - Exception when using factory to load router: {}\n{}", new Object[]{restxRequest, ex.getMessage(), factory.dumper()});
                } else {
                    logger.error("{} - Exception when using factory to load router: {}\nPro Tip: Set HTTP Header RestxDebug to have a dump of the factory in your logs when you get this error.", (Object)restxRequest, (Object)ex.getMessage());
                }
                throw ex;
            }
            finally {
                factory.close();
            }
        }
    }

    private class RecordingMainRouter
    implements RestxMainRouter {
        private final RestxMainRouter router;
        private final String serverId;
        private final RestxSpec.Storage storage;
        private final RestxSpec.StorageSettings storageSettings;
        private final RestxSpecRecorder.Repository repository;

        public RecordingMainRouter(String serverId, RestxMainRouter router, RestxSpec.StorageSettings storageSettings) {
            this.serverId = serverId;
            this.router = router;
            this.storageSettings = storageSettings;
            this.storage = RestxSpec.Storage.with(storageSettings);
            this.repository = new RestxSpecRecorder.Repository();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void route(RestxRequest restxRequest, RestxResponse restxResponse) throws IOException {
            Factory.LocalMachines.threadLocal().set("RecordedSpecsRepository", (Object)this.repository);
            if (!restxRequest.getRestxPath().startsWith("/@/") && "recording".equals(RestxMainRouterFactory.this.getMode(restxRequest))) {
                logger.debug("RECORDING {}", (Object)restxRequest);
                Factory factory = Factory.newInstance();
                Set recorders = factory.getComponents(RestxSpecRecorder.GivenRecorder.class);
                RestxSessionCookieFilter sessionFilter = (RestxSessionCookieFilter)factory.getComponent(RestxSessionCookieFilter.class);
                RestxSpecRecorder restxSpecRecorder = new RestxSpecRecorder(recorders, sessionFilter, this.storageSettings, this.repository);
                try {
                    Optional<String> recordPath = restxRequest.getHeader("RestxRecordPath");
                    RestxSpecTape tape = restxSpecRecorder.record(restxRequest, restxResponse, recordPath, restxRequest.getHeader("RestxRecordTitle"));
                    try {
                        this.router.route(tape.getRecordingRequest(), tape.getRecordingResponse());
                    }
                    finally {
                        RestxSpecRecorder.RecordedSpec recordedSpec = restxSpecRecorder.stop(tape);
                        if (recordPath.isPresent()) {
                            if (recordedSpec.getSpec() == null) {
                                logger.warn("can't save spec, not properly recorded for {}", (Object)restxRequest);
                            } else {
                                File recordFile = this.storage.store(recordedSpec.getSpec());
                                logger.info("saved recorded spec in {}", (Object)recordFile);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            } else {
                this.router.route(restxRequest, restxResponse);
            }
        }
    }

    private class CompilationManagerRouter
    implements RestxMainRouter {
        private final RestxMainRouter delegate;
        private final String rootPackage;
        private final CompilationManager compilationManager;
        private final Supplier<ImmutableSet<Class>> coldClasses;
        private ClassLoader classLoader;

        public CompilationManagerRouter(RestxMainRouter delegate, EventBus eventBus, Supplier<ImmutableSet<Class>> coldClasses, CompilationSettings compilationSettings) {
            this.delegate = delegate;
            this.coldClasses = Suppliers.memoize(coldClasses);
            this.rootPackage = (String)RestxMainRouterFactory.this.appSettings.appPackage().get();
            this.compilationManager = Apps.with(RestxMainRouterFactory.this.appSettings).newAppCompilationManager(eventBus, compilationSettings);
            eventBus.register(new Object(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Subscribe
                public void onCompilationFinished(CompilationFinishedEvent event) {
                    CompilationManagerRouter compilationManagerRouter = CompilationManagerRouter.this;
                    synchronized (compilationManagerRouter) {
                        CompilationManagerRouter.this.classLoader = null;
                    }
                }
            });
            this.compilationManager.incrementalCompile();
            if (RestxMainRouterFactory.this.useAutoCompile()) {
                this.compilationManager.startAutoCompile();
            }
        }

        private void setClassLoader() {
            this.classLoader = this.compilationManager.newHotReloadingClassLoader(this.rootPackage, (ImmutableSet)this.coldClasses.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void route(RestxRequest restxRequest, RestxResponse restxResponse) throws IOException {
            ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
            try {
                Collection lastDiagnostics;
                if (!RestxMainRouterFactory.this.useAutoCompile()) {
                    this.compilationManager.incrementalCompile();
                }
                if (!(lastDiagnostics = this.compilationManager.getLastDiagnostics()).isEmpty()) {
                    restxResponse.setStatus(HttpStatus.SERVICE_UNAVAILABLE);
                    restxResponse.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
                    PrintWriter restxResponseWriter = restxResponse.getWriter();
                    restxResponseWriter.write("COMPILATION ERROR(S):\n\n\n");
                    for (Diagnostic d : lastDiagnostics) {
                        if (d.getKind() == Diagnostic.Kind.NOTE) continue;
                        restxResponseWriter.write(d + "\n\n");
                    }
                    return;
                }
                CompilationManagerRouter compilationManagerRouter = this;
                synchronized (compilationManagerRouter) {
                    if (this.classLoader == null) {
                        this.setClassLoader();
                    }
                }
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.delegate.route(restxRequest, restxResponse);
            }
            catch (Factory.UnsatisfiedDependenciesException ex) {
                RestxMainRouterFactory.handleUnsatisfiedDependencyOnHotReload(restxResponse, ex, this.rootPackage);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousLoader);
            }
        }
    }

    private class HotReloadRouter
    implements RestxMainRouter {
        private final RestxMainRouter delegate;
        private final String rootPackage;
        private final Supplier<ImmutableSet<Class>> coldClasses;

        public HotReloadRouter(RestxMainRouter delegate, Supplier<ImmutableSet<Class>> coldClasses) {
            this.delegate = delegate;
            this.coldClasses = Suppliers.memoize(coldClasses);
            this.rootPackage = (String)RestxMainRouterFactory.this.appSettings.appPackage().get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void route(RestxRequest restxRequest, RestxResponse restxResponse) throws IOException {
            ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)new HotReloadingClassLoader(previousLoader, this.rootPackage, (ImmutableSet)this.coldClasses.get()));
                this.delegate.route(restxRequest, restxResponse);
            }
            catch (Factory.UnsatisfiedDependenciesException ex) {
                RestxMainRouterFactory.handleUnsatisfiedDependencyOnHotReload(restxResponse, ex, this.rootPackage);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousLoader);
            }
        }
    }

    public static final class Blade {
        private static final AtomicLong BLADE_COUNTER = new AtomicLong();
        private static final ThreadLocal<String> BLADE = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return "BLADE-" + BLADE_COUNTER.incrementAndGet();
            }
        };

        public static String current() {
            return BLADE.get();
        }

        public static String contextId(String serverId, String bladeId) {
            return serverId + "-" + bladeId;
        }

        public static Factory.LocalMachines bladeLocalMachines(String serverId) {
            return Factory.LocalMachines.contextLocal((String)Blade.contextId(serverId, Blade.current()));
        }
    }
}

