/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import restx.AbstractRouteLifecycleListener;
import restx.RestxContext;
import restx.RestxFilter;
import restx.RestxHandlerMatch;
import restx.RestxMainRouter;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.RestxRouter;
import restx.RestxRouting;
import restx.WebException;
import restx.common.metrics.api.MetricRegistry;
import restx.common.metrics.api.Monitor;
import restx.exceptions.RestxError;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Factory;
import restx.factory.NamedComponent;
import restx.http.HttpStatus;

public class StdRestxMainRouter
implements RestxMainRouter {
    private static final Logger logger = LoggerFactory.getLogger(StdRestxMainRouter.class);
    private final RestxRouting routing;
    private final String mode;
    private final MetricRegistry metrics;

    public static Builder builder() {
        return new Builder();
    }

    private static MetricRegistry getMetricsRegistryComponent() {
        return (MetricRegistry)Factory.getInstance().getComponent(MetricRegistry.class);
    }

    public StdRestxMainRouter(RestxRouting routing) {
        this(routing, "prod");
    }

    public StdRestxMainRouter(RestxRouting routing, String mode) {
        this(StdRestxMainRouter.getMetricsRegistryComponent(), routing, mode);
    }

    public StdRestxMainRouter(MetricRegistry metrics, RestxRouting routing, String mode) {
        this.metrics = (MetricRegistry)Preconditions.checkNotNull((Object)metrics);
        this.routing = (RestxRouting)Preconditions.checkNotNull((Object)routing);
        this.mode = (String)Preconditions.checkNotNull((Object)mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void route(RestxRequest restxRequest, RestxResponse restxResponse) throws IOException {
        logger.debug("<< {}", (Object)restxRequest);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Monitor monitor = this.metrics.timer("<HTTP> " + restxRequest.getHttpMethod() + " " + restxRequest.getRestxPath()).time();
        try {
            Optional<RestxRouting.Match> m = this.routing.match(restxRequest);
            if (!m.isPresent()) {
                String path = restxRequest.getRestxPath();
                StringBuilder sb = new StringBuilder().append("no restx route found for ").append(restxRequest.getHttpMethod()).append(" ").append(path).append("\n");
                if (this.hasApiDocs()) {
                    sb.append("go to ").append(restxRequest.getBaseUri()).append("/@/ui/api-docs/").append(" for API documentation\n\n");
                }
                sb.append("routes:\n").append("-----------------------------------\n");
                for (RestxRoute route : this.routing.getRoutes()) {
                    sb.append(route).append("\n");
                }
                sb.append("-----------------------------------");
                restxResponse.setStatus(HttpStatus.NOT_FOUND);
                restxResponse.setContentType("text/plain");
                PrintWriter out = restxResponse.getWriter();
                out.print(sb.toString());
            } else {
                MDC.put((String)"restx.path", (String)restxRequest.getRestxPath());
                MDC.put((String)"restx.method", (String)restxRequest.getHttpMethod());
                logger.debug("<< {}\nHANDLERS: {}", (Object)restxRequest, ((RestxRouting.Match)m.get()).getMatches());
                RestxContext context = new RestxContext(this.getMode(), new AbstractRouteLifecycleListener(){}, (ImmutableList<RestxHandlerMatch>)ImmutableList.copyOf(((RestxRouting.Match)m.get()).getMatches()));
                RestxHandlerMatch match = context.nextHandlerMatch();
                match.handle(restxRequest, restxResponse, context);
            }
        }
        catch (JsonProcessingException ex) {
            logger.warn("request raised " + ((Object)((Object)ex)).getClass().getSimpleName(), (Throwable)ex);
            restxResponse.setStatus(HttpStatus.BAD_REQUEST);
            restxResponse.setContentType("text/plain");
            PrintWriter out = restxResponse.getWriter();
            if (restxRequest.getContentStream() instanceof BufferedInputStream) {
                try {
                    JsonLocation location = ex.getLocation();
                    restxRequest.getContentStream().reset();
                    out.println(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ((Object)((Object)ex)).getClass().getSimpleName()) + ". Please verify your input:");
                    List lines = CharStreams.readLines((Readable)new InputStreamReader(restxRequest.getContentStream()));
                    if (lines.isEmpty()) {
                        if ("application/x-www-form-urlencoded".equalsIgnoreCase(restxRequest.getContentType())) {
                            out.println("Body was considered as parameter due to Content-Type: " + restxRequest.getContentType() + ". Setting your Content-Type to \"application/json\" may resolve the problem");
                        } else {
                            out.println("Empty body. Content-type was \"" + restxRequest.getContentType() + "\"");
                        }
                    } else {
                        out.println("<-- JSON -->");
                        for (int i = 0; i < lines.size(); ++i) {
                            String line = (String)lines.get(i);
                            out.println(line);
                            if (location == null || i + 1 != location.getLineNr()) continue;
                            boolean farColumn = location.getColumnNr() > 80;
                            out.println(Strings.repeat((String)" ", (int)Math.max(0, location.getColumnNr() - 2)) + "^");
                            out.println(Strings.repeat((String)(farColumn ? ">" : " "), (int)Math.max(0, location.getColumnNr() - ex.getOriginalMessage().length() / 2 - 3)) + ">> " + ex.getOriginalMessage() + " <<");
                            out.println();
                        }
                        out.println("</- JSON -->");
                    }
                    restxRequest.getContentStream().reset();
                    logger.debug(((Object)((Object)ex)).getClass().getSimpleName() + " on " + restxRequest + ". message: " + ex.getMessage() + ". request content: " + CharStreams.toString((Readable)new InputStreamReader(restxRequest.getContentStream())));
                }
                catch (IOException e) {
                    logger.warn("io exception raised when trying to provide original input to caller", (Throwable)e);
                    out.println(ex.getMessage());
                }
            }
        }
        catch (RestxError.RestxException ex) {
            logger.debug("request raised RestxException", (Throwable)ex);
            restxResponse.setStatus(ex.getErrorStatus());
            restxResponse.setContentType("application/json");
            PrintWriter out = restxResponse.getWriter();
            out.println(ex.toJSON());
        }
        catch (WebException ex) {
            ex.writeTo(restxRequest, restxResponse);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            logger.warn("request raised " + ex.getClass().getSimpleName() + ": " + ex.getMessage(), (Throwable)ex);
            restxResponse.setStatus(HttpStatus.BAD_REQUEST);
            restxResponse.setContentType("text/plain");
            PrintWriter out = restxResponse.getWriter();
            out.println("UNEXPECTED CLIENT ERROR:");
            out.print(ex.getMessage());
        }
        catch (WrappedCheckedException wrappedException) {
            Throwable ex = wrappedException.getCause();
            logger.error("request raised " + ex.getClass().getSimpleName() + ": " + ex.getMessage(), ex);
            restxResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            restxResponse.setContentType("text/plain");
            PrintWriter out = restxResponse.getWriter();
            out.println("UNEXPECTED SERVER ERROR:");
            out.print(ex.getMessage());
        }
        catch (Throwable ex) {
            logger.error("request raised " + ex.getClass().getSimpleName() + ": " + ex.getMessage(), ex);
            restxResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            restxResponse.setContentType("text/plain");
            PrintWriter out = restxResponse.getWriter();
            out.println("UNEXPECTED SERVER ERROR:");
            out.print(ex.getMessage());
        }
        finally {
            try {
                restxRequest.closeContentStream();
            }
            catch (Exception ex) {}
            try {
                restxResponse.close();
            }
            catch (Exception ex) {}
            monitor.stop();
            stopwatch.stop();
            restxResponse.getLogLevel().log(logger, restxRequest, restxResponse, stopwatch);
            MDC.clear();
        }
    }

    String getMode() {
        return this.mode;
    }

    private boolean hasApiDocs() {
        for (RestxRoute route : this.routing.getRoutes()) {
            if (!route.getClass().getName().endsWith("ApiDocsUIRoute")) continue;
            return true;
        }
        return false;
    }

    public int getNbFilters() {
        return this.routing.getFilters().size();
    }

    public int getNbRoutes() {
        return this.routing.getRoutes().size();
    }

    public static class Builder {
        private MetricRegistry metrics;
        private String mode = "prod";
        private int priority = 0;
        private List<NamedComponent<RestxFilter>> filters = Lists.newArrayList();
        private List<NamedComponent<RestxRouteFilter>> routeFilters = Lists.newArrayList();
        private List<RestxRoute> routes = Lists.newArrayList();

        public Builder withMetrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder inMode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder addFilter(RestxFilter filter) {
            int filterPriority = this.priority++;
            this.filters.add((NamedComponent<RestxFilter>)NamedComponent.of(RestxFilter.class, (String)("Filter" + filterPriority), (int)filterPriority, (Object)filter));
            return this;
        }

        public Builder addFilter(RestxRouteFilter filter) {
            int filterPriority = this.priority++;
            this.routeFilters.add((NamedComponent<RestxRouteFilter>)NamedComponent.of(RestxRouteFilter.class, (String)("RouteFilter" + filterPriority), (int)filterPriority, (Object)filter));
            return this;
        }

        public Builder addRouter(RestxRouter router) {
            this.routes.addAll((Collection<RestxRoute>)router.getRoutes());
            return this;
        }

        public Builder addRoute(RestxRoute route) {
            this.routes.add(route);
            return this;
        }

        public RestxMainRouter build() {
            return new StdRestxMainRouter(this.metrics == null ? StdRestxMainRouter.getMetricsRegistryComponent() : this.metrics, new RestxRouting((ImmutableList<NamedComponent<RestxFilter>>)ImmutableList.copyOf(this.filters), (ImmutableList<NamedComponent<RestxRouteFilter>>)ImmutableList.copyOf(this.routeFilters), (ImmutableList<RestxRoute>)ImmutableList.copyOf(this.routes)), this.mode);
        }
    }
}

